//------------------------------------------------------------------------------
//	C2000types.h - Define data types used by C2000ware.
//	Define a subset of contents in C2000ware header file F2837xD_device.h.
//	We do not use F2837xD_device.h to avoid conflicts on DSP subsystems
//	for which we are using legacy device and register definitions.
//  Created on: Sep 2, 2021
//      Author: TVCox
//------------------------------------------------------------------------------

#ifndef DSP_C2000TYPES_H_
#define DSP_C2000TYPES_H_


#ifdef __cplusplus
extern "C" {
#endif

//
// Common CPU Definitions:
//
extern __cregister volatile unsigned int IFR;
extern __cregister volatile unsigned int IER;

#define  EINT   __asm(" clrc INTM")
#define  DINT   __asm(" setc INTM")
#define  ERTM   __asm(" clrc DBGM")
#define  DRTM   __asm(" setc DBGM")
#ifndef  EALLOW
#define  EALLOW __asm(" EALLOW")
#endif
#ifndef  EDIS
#define  EDIS   __asm(" EDIS")
#endif
#define  ESTOP0 __asm(" ESTOP0")

#define M_INT1  0x0001
#define M_INT2  0x0002
#define M_INT3  0x0004
#define M_INT4  0x0008
#define M_INT5  0x0010
#define M_INT6  0x0020
#define M_INT7  0x0040
#define M_INT8  0x0080
#define M_INT9  0x0100
#define M_INT10 0x0200
#define M_INT11 0x0400
#define M_INT12 0x0800
#define M_INT13 0x1000
#define M_INT14 0x2000
#define M_DLOG  0x4000
#define M_RTOS  0x8000

//	From TI C2000ware:
//	The following data types are included for compatibility with legacy code.
//	They are not recommended for use in new software.
//	Please use the C99 types included above.
//
#ifndef DSP28_DATA_TYPES
#define DSP28_DATA_TYPES
typedef int             	int16;
typedef long            	int32;
typedef long long			int64;
typedef unsigned int    	Uint16;
typedef unsigned long   	Uint32;
typedef unsigned long long	Uint64;
typedef float           	float32;
typedef long double     	float64;
#endif

//#if 0
// The following data types are for use with byte addressable peripherals.
// See compiler documentation on the byte_peripheral type attribute.

#ifndef __TMS320C28XX_CLA__
#if __TI_COMPILER_VERSION__ >= 16006000
#ifndef DSPBP_DATA_TYPES
#define DSPBP_DATA_TYPES
typedef unsigned int bp_16 __attribute__((byte_peripheral));
typedef unsigned long bp_32 __attribute__((byte_peripheral));
#endif		//	!defined DSPBP_DATA_TYPES
#endif
#endif
//#endif		//	0


#ifdef __cplusplus
}
#endif                                  // extern "C"


//-----------------------------------------------------------------------------
#endif		//	DSP_C2000TYPES_H_


//-----------------------------------------------------------------------------
//	end of file C2000types.h
