;;------------------------------------------------------------------------------
;; F2837xD_TIME_a.asm
;;------------------------------------------------------------------------------
;; Implements a software 1us (roughly) timing delay loop.
;; Add any added time-related assembly functions here.
;;------------------------------------------------------------------------------

;;------------------------------------------------------------------------------
;;!    void SWTimeDlyMicroSec( INT16U nNumMicrosec )
;;
;;! Execute a SW time delay loop in microseconds.
;;!
;;!  1) The execution time of this routine is based upon a 150 MHz
;;!     CPUCLK. If still executing at the startup clock speed of 15 MHz,
;;!     then the execution speed will be 10X slower.
;;!
;;!  2) It also assumes that the function executes out of internal RAM.
;;!     If executing out of internal flash or external memory, then the
;;!     execution speed will be slightly slower.
;;!
;;!     However, the inner loop of this function is essentially
;;!     invariant to the memory it is running in.  Therefore, even
;;!     when running in flash memory, the basic loop time will be
;;!     only slightly longer than 1 us.
;;!
;;!  3) The entire routine is interruptable and unaware of any such
;;!     occurrence. The only guarantee the routine makes is to delay
;;!     for "at least" nNumMicrosec with no apology for taking longer.
;;!
;;! \param[in]  nNumMicrosec       #of microseconds
;;! \return     none
;;------------------------------------------------------------------------------

    .def    _SWTimeDlyMicroSec_Asm
    .sect   .text

_SWTimeDlyMicroSec_Asm:
    
    ; The call and return are each 4 CPU cycles - ignored.
    ; BF is 4, either way (condition T or F)
    ; MOV, SUBB are each 1
    ; Loop maintenance is 6, subtract that from calc:
    ;   N = 150/5 - 6 = 24
    ; Testing shows this number is too small, 29 is "just right" for a F28335 DSP target running at 150 MHz.
    ; Testing shows that 39 is approximately accurate for a F2837xD target running at 200 MHz.

outerloop:						;; For 1 usec use #39 for a 200 MHz processor. Use #29 for 150 MHz processor.
    MOV     AH,#4              ;; Load # which yields ~ 1 usec - Modified from the original to delay ~0.1 usec
innerloop:
    SUBB    AH,#1               ;; decrement outer loop counter
    BF      innerloop,GT        ;; branch for outer loop

    SUBB    AL,#1               ;; decrement outer loop counter
    BF      outerloop,GT        ;; branch for outer loop

    LRETR                       ;; return

;;------------------------------------------------------------------------------
;; end of F2837xD_TIME_a.asm
