//
// Included Files
//
#include "driverlib_cm.h"
#include "cm.h"

#include "cm_board.h"

#include "enet.h"


IPC_MessageQueue_t messageQueue1;
IPC_Message_t TxMsg1, RxMsg1;

//#define IPC_SYNC 		IPC_FLAG31

uint32_t EntryAddr = 0x0210000;
#define jumpEntryAddr 	(void (*)(void))0x0210000

unsigned long IPAddr =  0xAC100004; // 0xAC100004; //172.16.0.4
unsigned long NetMask = 0xFFFF0000;
unsigned long GWAddr = 0x00000000;

/*void exit(uint32_t address){
    //
    // Jump to entry address
    //
    __asm("   bx r0");
}*/

//
// Main
//
void main(void)
{
    //
    // Initialize device clock and peripherals
    //
    CM_init();

    //
    // Initialize GPIO and configure the GPIO pin as a push-pull output
    //
    // This is configured by CPU1

#ifdef ETHERNET

    unsigned long ulUser0, ulUser1;
    unsigned char pucMACArray[8];

    //
    // ENET INIT
    //
    SYSTICK_setPeriod(systickPeriodValue);
    SYSTICK_enableCounter();
    SYSTICK_registerInterruptHandler(SysTickIntHandler);
    SYSTICK_enableInterrupt();

    //
    // Enable processor interrupts.
    //
    Interrupt_enableInProcessor();

    // Set user/company specific MAC octets
    // (for this code we are using A8-63-F2-00-00-80)
    // 0x00 MACOCT3 MACOCT2 MACOCT1
    ulUser0 = 0x00F263A8;

    // 0x00 MACOCT6 MACOCT5 MACOCT4
    ulUser1 = 0x00800000;

    //
    // Convert the 24/24 split MAC address from NV ram into a 32/16 split MAC
    // address needed to program the hardware registers, then program the MAC
    // address into the Ethernet Controller registers.
    //
    pucMACArray[0] = ((ulUser0 >>  0) & 0xff);
    pucMACArray[1] = ((ulUser0 >>  8) & 0xff);
    pucMACArray[2] = ((ulUser0 >> 16) & 0xff);
    pucMACArray[3] = ((ulUser1 >>  0) & 0xff);
    pucMACArray[4] = ((ulUser1 >>  8) & 0xff);
    pucMACArray[5] = ((ulUser1 >> 16) & 0xff);
    //
    // Initialize ethernet module.
    //
    Ethernet_init(pucMACArray);

    //
    // Initialze the lwIP library, using DHCP.
    //
    lwIPInit(0, pucMACArray, IPAddr, NetMask, GWAddr, IPADDR_USE_STATIC);

    // Initialize the UDP server
    //
    my_udp_init();

    Interrupt_setPriority(INT_EMAC_TX0, 3);
    Interrupt_setPriority(INT_EMAC_RX0, 2);
    Interrupt_enable(INT_EMAC_TX0);
    Interrupt_enable(INT_EMAC_RX0);
    Interrupt_enable(INT_EMAC);

#endif

	DEVICE_DELAY_US(500000);
	GPIO_writePin(mGPIO_PIN_LED5, 1);
	DEVICE_DELAY_US(500000);
	GPIO_writePin(mGPIO_PIN_LED5, 0);
	DEVICE_DELAY_US(2000000);
	GPIO_writePin(mGPIO_PIN_LED5, 1);

    IPC_sync(IPC_CM_L_CPU1_R, IPC_SYNC);

    GPIO_writePin(mGPIO_PIN_LED5, 0);

    IPC_clearFlagLtoR(IPC_CM_L_CPU1_R, IPC_FLAG_ALL);

//    IPC_initMessageQueue(IPC_CM_L_CPU1_R, &messageQueue1, IPC_INT1, IPC_INT1);

//    exit(EntryAddr);

    for(;;)
    {
    	GPIO_togglePin(mGPIO_PIN_LED5);
    	DEVICE_DELAY_US(300000);	// Լ500ms
    	GPIO_togglePin(mGPIO_PIN_LED5);
    	DEVICE_DELAY_US(300000);
    	GPIO_togglePin(mGPIO_PIN_LED5);
    	DEVICE_DELAY_US(300000);
    	GPIO_togglePin(mGPIO_PIN_LED5);
    	DEVICE_DELAY_US(300000);
    	GPIO_togglePin(mGPIO_PIN_LED5);
    	DEVICE_DELAY_US(300000);	// Լ500ms
    	GPIO_togglePin(mGPIO_PIN_LED5);
    	DEVICE_DELAY_US(300000);
    	GPIO_togglePin(mGPIO_PIN_LED5);
    	DEVICE_DELAY_US(300000);
    	GPIO_togglePin(mGPIO_PIN_LED5);
    	DEVICE_DELAY_US(300000);

	    __asm(" mov r0, #0x00200000");
	    __asm(" mov pc, r0");

//    __asm(" mov r0, #0x00200000");
//    __asm(" mov pc, r0");
    }
}

//
// End of File
//
