/*
 * bootloader_enet.h
 *
 *  Created on: 2023711
 *      Author: 35b259
 */

#ifndef SERVO_HEADER_SERVO_ENET_H_
#define SERVO_HEADER_SERVO_ENET_H_

#include <string.h>

#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "inc/hw_nvic.h"
#include "inc/hw_types.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_emac.h"

#include "driverlib_cm/ethernet.h"
#include "driverlib_cm/gpio.h"
#include "driverlib_cm/interrupt.h"
#include "driverlib_cm/flash.h"

#include "driverlib_cm/sysctl.h"
#include "driverlib_cm/systick.h"

#include "utils/lwiplib.h"
#include "board_drivers/pinout.h"

#include "lwipopts.h"

//
// Defines
//

#define PHY_SPECIFIC_STATUS_REG		0x11

#define PHY_REG_REALTIMELINKSTATUS_MASK 0x400

#define REALTIMELINKSTATUS 10

#define PAYLOAD 1088

#define ENETPAYLOAD 1024

#define TEST_PASS       0x5555
#define TEST_FAIL       0xAAAA

#define PACKET_LENGTH 	132

#define MAKE_IP_ADDRESS(a0,a1,a2,a3) (((a0<<24) & 0xFF000000) | ((a1<<16) & 0x00FF0000) | ((a2<<8)  & 0x0000FF00) | (a3 & 0x000000FF) )

extern volatile uint32_t msTime;
extern volatile bool flag_TX_frame_UDP;

extern struct udp_pcb *g_upcb;
extern struct udp_pcb *g_wave_upcb;

extern struct pbuf *pbuf1_tx;

//extern bool Connected_udp_28000;

extern uint16_t cnt_Connected_udp_28000;

extern char * buf_tx_start_msg;
extern uint32_t buf_tx_start_msg_count;
extern uint16_t cont_rx_udp;
extern uint32_t systickPeriodValue;

extern u8_t buf_rx[PAYLOAD];
//extern u8_t buf_tx[PAYLOAD];

extern void Ethernet_init(const unsigned char *mac);
extern void Ethernet_setMACConfigurationCustom(uint32_t base, uint32_t flags);
extern void Ethernet_clearMACConfigurationCustom(uint32_t base, uint32_t flags);
extern void Ethernet_performPushOnPacketQueueCustom(Ethernet_PKT_Queue_T *pktQueuePtr,
													Ethernet_Pkt_Desc *pktDescHdrPtr);
extern Ethernet_Pkt_Desc *Ethernet_performPopOnPacketQueueCustom(
            										Ethernet_PKT_Queue_T *pktQueuePtr);
extern void Ethernet_releaseTxPacketBufferCustom(Ethernet_Handle handleApplication,
												 Ethernet_Pkt_Desc *pPacket);
extern Ethernet_Pkt_Desc* Ethernet_receivePacketCallbackCustom(
											Ethernet_Handle handleApplication,
											Ethernet_Pkt_Desc *pPacket);
extern Ethernet_Pkt_Desc* Ethernet_getPacketBufferCustom(void);
extern Ethernet_Pkt_Desc* lwIPEthernetIntHandler(Ethernet_Pkt_Desc *pPacket);

//extern void udp_rx_callback(void *arg, struct udp_pcb *upcb, struct pbuf *p,
//               struct ip_addr *addr, u16_t port);

extern void my_udp_init(void);

extern void SysTickIntHandler(void);

void httpLEDToggle(void);
void lwIPHostTimerHandler(void);

#endif /* SERVO_HEADER_SERVO_ENET_H_ */
