
#include "cpu1_board.h"

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    PinMux_init();
    GPIO_init();
    IPC_SYSCFG_init();
    ETHERNET_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	//
	// ETHERNET -> myETHERNET0 Pinmux
	//
	GPIO_setPinConfig(myETHERNET0_ENETMII_RX_CLK_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_RX_CLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_RX_CLK_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_RX_DV_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_RX_DV_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_RX_DV_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_RX_ERR_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_RX_ERR_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_RX_ERR_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_RX_DATA0_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_RX_DATA0_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_RX_DATA0_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_RX_DATA1_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_RX_DATA1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_RX_DATA1_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_RX_DATA2_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_RX_DATA2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_RX_DATA2_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_RX_DATA3_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_RX_DATA3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_RX_DATA3_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_TX_EN_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_TX_EN_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_TX_EN_GPIO, GPIO_QUAL_ASYNC);

//	GPIO_setPinConfig(myETHERNET0_ENETMII_TX_CLK_PIN_CONFIG);
//	GPIO_setPadConfig(myETHERNET0_ENETMII_TX_CLK_GPIO, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(myETHERNET0_ENETMII_TX_CLK_GPIO, GPIO_QUAL_ASYNC);
//
//	GPIO_setPinConfig(myETHERNET0_ENETMII_TX_DATA0_PIN_CONFIG);
//	GPIO_setPadConfig(myETHERNET0_ENETMII_TX_DATA0_GPIO, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(myETHERNET0_ENETMII_TX_DATA0_GPIO, GPIO_QUAL_ASYNC);

    // controlCARD
    GPIO_setPinConfig(GPIO_44_ENET_MII_TX_CLK);
    GPIO_setPadConfig(44, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(44, GPIO_QUAL_ASYNC);

    // controlCARD
    GPIO_setPinConfig(GPIO_75_ENET_MII_TX_DATA0);
    GPIO_setPadConfig(75, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(75, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_TX_DATA1_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_TX_DATA1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_TX_DATA1_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_TX_DATA2_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_TX_DATA2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_TX_DATA2_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMII_TX_DATA3_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMII_TX_DATA3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMII_TX_DATA3_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMDIO_CLK_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMDIO_CLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMDIO_CLK_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myETHERNET0_ENETMDIO_DATA_PIN_CONFIG);
	GPIO_setPadConfig(myETHERNET0_ENETMDIO_DATA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myETHERNET0_ENETMDIO_DATA_GPIO, GPIO_QUAL_ASYNC);

    // GPIO145 -> LED5 Pinmux
    GPIO_setPinConfig(mGPIO_LED5_GPIO_PIN_CONFIG);
    // GPIO146 -> LED4 Pinmux
    GPIO_setPinConfig(mGPIO_LED4_GPIO_PIN_CONFIG);
    // GPIO147 -> LED12 Pinmux
    GPIO_setPinConfig(mGPIO_LED12_GPIO_PIN_CONFIG);

	// GPIO119 -> mPhyRest Pinmux
	GPIO_setPinConfig(mPhyRest_GPIO_PIN_CONFIG);
}

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
void GPIO_init(){
    mGPIO145_init();
    mGPIO146_init();
    mGPIO147_init();
    mPhyRest_init();
}

void mGPIO145_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED5, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED5, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED5, GPIO_DIR_MODE_OUT);
//    GPIO_setControllerCore(mGPIO_PIN_LED5, GPIO_CORE_CPU1_CLA1);
//    GPIO_setControllerCore(mGPIO_PIN_LED5, GPIO_CORE_CPU2);
    GPIO_setControllerCore(mGPIO_PIN_LED5, GPIO_CORE_CM);

//    GPIO_writePin(mGPIO_PIN_LED5, 0);
}
void mGPIO146_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED4, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED4, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED4, GPIO_DIR_MODE_OUT);
    GPIO_setControllerCore(mGPIO_PIN_LED4, GPIO_CORE_CPU1);
//    GPIO_setControllerCore(mGPIO_PIN_LED4, GPIO_CORE_CPU1);
//    GPIO_setControllerCore(mGPIO_PIN_LED4, GPIO_CORE_CPU2);
//    GPIO_setControllerCore(mGPIO_PIN_LED4, GPIO_CORE_CPU1_CLA1);

//    GPIO_writePin(mGPIO_PIN_LED4, 0);
}
void mGPIO147_init(){
    GPIO_setPadConfig(mGPIO_PIN_LED12, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(mGPIO_PIN_LED12, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(mGPIO_PIN_LED12, GPIO_DIR_MODE_OUT);
    GPIO_writePin(mGPIO_PIN_LED12, 0);  		// led12Ϊ͵ƽЧ
    GPIO_setControllerCore(mGPIO_PIN_LED12, GPIO_CORE_CPU1);
}

//
//PHY Reset Pin to be driven High to bring external PHY out of Reset
//
void mPhyRest_init(){
	GPIO_writePin(mPhyRest, 1);
	GPIO_setPadConfig(mPhyRest, GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(mPhyRest, GPIO_QUAL_ASYNC);
	GPIO_setDirectionMode(mPhyRest, GPIO_DIR_MODE_OUT);
	GPIO_setControllerCore(mPhyRest, GPIO_CORE_CPU1);
}

//*****************************************************************************
//
// ETHERNET Configurations
//
//*****************************************************************************
void ETHERNET_init(){
    myETHERNET0_init();
}

void myETHERNET0_init(){
    //--------------------------------controlCARD--------------------------------------//
    //
    //Power down pin to bring the external PHY out of Power down
    //
    GPIO_setDirectionMode(108, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(108, GPIO_PIN_TYPE_PULLUP);
    GPIO_writePin(108,1);

    //---------------------------------------------------------------------------------//
}

//*****************************************************************************
//
// IPC Configurations
//
//*****************************************************************************
void IPC_SYSCFG_init(){
    //
    // Paste the following line in your main() function after device_init, if you would like CPU2 to boot
    // Device_bootCPU2(BOOT_MODE_CPU2);
    //
}

//void IPC





