


#include "cpu1_board.h"
#include <string.h>

/**
 * main.c
 */
uint32_t main(void)
{
    //
    // Initialize device clock and peripherals
    //
    Device_init();

#ifdef _FLASH
    // Send boot command to allow the CPU2 application to begin execution
    Device_bootCM(BOOTMODE_BOOT_TO_FLASH_SECTOR0);
#endif

    //
    // init interrupt and vectorTable, drivelib.
    //
    Interrupt_initModule();
    Interrupt_initVectorTable();

    Board_init();

	GPIO_writePin(mGPIO_PIN_LED4, 1);
	DEVICE_DELAY_US(1000000);
	GPIO_writePin(mGPIO_PIN_LED4, 0);
	DEVICE_DELAY_US(1000000);
	GPIO_writePin(mGPIO_PIN_LED4, 1);
	DEVICE_DELAY_US(1000000);
	GPIO_writePin(mGPIO_PIN_LED4, 0);

//    IPC_clearFlagLtoR(IPC_CPU1_L_CM_R, IPC_FLAG_ALL);
//    IPC_initMessageQueue(IPC_CPU1_L_CM_R, &messageQueue1, IPC_INT1, IPC_INT1);

    EINT;
    ERTM;

    IPC_sync(IPC_CPU1_L_CM_R, IPC_SYNC);

    IPC_clearFlagLtoR(IPC_CPU1_L_CM_R, IPC_FLAG_ALL);

    // jump to CPU1_APP
    asm("    LB 0x088000");

//	return 0;
    while(1)
    {

    	GPIO_writePin(mGPIO_PIN_LED4, 1);
		DEVICE_DELAY_US(500000);
		GPIO_writePin(mGPIO_PIN_LED4, 0);
		DEVICE_DELAY_US(500000);

//		asm("    LB 0x088000");
    }
}




