MEMORY
{

PAGE 0:
	FLASH				: origin = 0x3F6000, length = 0x001F7C
	CODESTART			: origin = 0x3F7FF6, length = 0x000002

	RAMM0				: origin = 0x000050, length = 0x0003B0
	RAML3				: origin = 0x009000, length = 0x001000

PAGE 1:
	RAMM1				: origin = 0x000400, length = 0x000400
	RAML0				: origin = 0x008000, length = 0x000800
	RAML1				: origin = 0x008800, length = 0x000400
	RAML2				: origin = 0x008C00, length = 0x000400

	BOOT_RSVD			: origin = 0x000000, length = 0x000050

	OTP					: origin = 0x3D7800, length = 0x000400
	CSM_RSVD			: origin = 0x3F7F80, length = 0x000076
	CSM_PWL				: origin = 0x3F7FF8, length = 0x000008

	BOOTROM				: origin = 0x3FF27C, length = 0x000D44
	RESET				: origin = 0x3FFFC0, length = 0x000002
	VECTORS				: origin = 0x3FFFC2, length = 0x00003E
}

SECTIONS
{
	ramfuncs 		: LOAD = FLASH, RUN = RAMM0, TABLE(BINIT), PAGE = 0
	.binit				: > FLASH, PAGE = 0

	.text				: > FLASH,				PAGE = 0
	.cinit				: > FLASH,				PAGE = 0
	.econst				: > FLASH,				PAGE = 0
	.switch				: > FLASH,				PAGE = 0

	.stack				: > RAMM1,				PAGE = 1
	.ebss				: > RAML0,				PAGE = 1
	.sysmem				: > RAML1,				PAGE = 1

	csm_rsvd			: > CSM_RSVD,			PAGE = 1, TYPE = DSECT
	.reset				: > RESET,				PAGE = 1, TYPE = DSECT
	vectors				: > VECTORS,			PAGE = 1, TYPE = DSECT

	codestart			: > CODESTART,			PAGE = 0
}
