#include "DSP2803x_Device.h"

#define CPU_RATE 16.667L

#define DELAY_US(A)  DSP28x_usDelay((long)((((long double) A * 1000.0L) / (long double)CPU_RATE) - 9.0L) / 5.0L)

void DSP28x_usDelay(long cycle);

void initClock(void) {
	__eallow();
	SysCtrlRegs.CLKCTL.bit.INTOSC1OFF 		= 0;
	SysCtrlRegs.CLKCTL.bit.INTOSC2OFF 		= 1;
	SysCtrlRegs.CLKCTL.bit.OSCCLKSRCSEL 	= 0;
	SysCtrlRegs.CLKCTL.bit.XCLKINOFF 		= 1;
	SysCtrlRegs.CLKCTL.bit.XTALOSCOFF 		= 1;
	SysCtrlRegs.CLKCTL.bit.TMR2CLKPRESCALE 	= 0;
	__edis();
	if (SysCtrlRegs.PLLSTS.bit.MCLKSTS != 0) {
		__eallow();
		SysCtrlRegs.PLLSTS.bit.MCLKCLR = 1;
		__edis();
	}
	if (SysCtrlRegs.PLLSTS.bit.DIVSEL != 0) {
		__eallow();
		SysCtrlRegs.PLLSTS.bit.DIVSEL = 0;
		__edis();
	}
	if (SysCtrlRegs.PLLCR.bit.DIV != 12) {
		__eallow();
		SysCtrlRegs.PLLSTS.bit.MCLKOFF = 1;
		SysCtrlRegs.PLLCR.bit.DIV = 12;
		__edis();
		while (SysCtrlRegs.PLLSTS.bit.PLLLOCKS != 1) {}
		__eallow();
		SysCtrlRegs.PLLSTS.bit.MCLKOFF = 0;
		__edis();
	}
	__eallow();
	SysCtrlRegs.PLLSTS.bit.DIVSEL = 2;
	__edis();
}

#pragma CODE_SECTION(initFlash, "ramfuncs")
void initFlash(void) {
   __eallow();
   FlashRegs.FOPT.bit.ENPIPE = 1;
   FlashRegs.FBANKWAIT.bit.PAGEWAIT = 3;
   FlashRegs.FBANKWAIT.bit.RANDWAIT = 3;
   FlashRegs.FOTPWAIT.bit.OTPWAIT = 5;
   FlashRegs.FSTDBYWAIT.bit.STDBYWAIT = 0x01FF;
   FlashRegs.FACTIVEWAIT.bit.ACTIVEWAIT = 0x01FF;
   __edis();
   __asm(" RPT #7 || NOP");
}

void main(void) {
	initClock();
	initFlash();

	__eallow();
	SysCtrlRegs.PCLKCR1.bit.EPWM1ENCLK = 1;
	SysCtrlRegs.PCLKCR0.bit.HRPWMENCLK = 1;

	EPwm1Regs.TBCTL.bit.CTRMODE = 2;
    EPwm1Regs.AQCTLA.bit.CAU = 1;
    EPwm1Regs.AQCTLA.bit.CAD = 2;
	EPwm1Regs.TBPRD = 200;
	EPwm1Regs.CMPA.half.CMPA = 50;
    EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;     // Shadow mode
	EPwm1Regs.CMPCTL.bit.LOADAMODE = 2;		// load on CTR = PRD
	EPwm1Regs.HRPWR.bit.MEPOFF = 0;
    EPwm1Regs.HRCNFG.bit.EDGMODE = 2;
    EPwm1Regs.HRCNFG.bit.AUTOCONV = 1;
	EPwm1Regs.HRCNFG.bit.HRLOAD = 1;		// load on CTR = PRD

	GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;
	__edis();

	for (;;) {
		DELAY_US(10);
		EPwm1Regs.CMPA.half.CMPAHR = 0;
		DELAY_US(10);
		EPwm1Regs.CMPA.half.CMPAHR = (220U << 8);
	}
}
