/**
 * @file board_mapping.h
 * @brief This file provides the pin and function mappings for each
 *        available rockstarcore based board
 *
 * @author  Firmware department
 * @copyright Ingenia Motion Control (c) 2016. All rights reserved.
 */

/**
 * \defgroup BoardMapping Board-MCU mapping
 *
 * @{
 */

#ifndef BOARD_CONFIG_H
#define BOARD_CONFIG_H

#define WORD_SIZE                   2

/* MCU description */
#define NUMBER_OF_PROCESSORS        2
#define CPU_1                       0
#define CPU_2                       1

#define NUMBER_OF_COPROCESSORS  2

#define NUMBER_OF_COPRO_CORE_1      1
#define COPRO_CORE1_INSTANCE_1      0
#define INTERPROCESSOR_1_ID         0x1000
#define INTERPROCESSOR_1_DESCRIPTOR {'C','O','P','R','O', '1', '\n', 0}

#define NUMBER_OF_COPRO_CORE_2  1
#define COPRO_CORE1_INSTANCE_1  0

/* Analog to digital converter modules */
#define NUMBER_OF_ADC_INSTANCES 1

#define ADC_INSTANCE_1      0
#define ADC_1_ID            0x1400
#define ADC_1_DESCRIPTOR    {'A','D','C','1', '\n', 0, 0, 0}

/* Number of bytes of the ADC instance */
#define ADC_INST_RESOLUTION_1   12

/* Modulated outputs */
#define NUMBER_OF_MODULATED_PHASE 1

#define MODULATED_PHASE_INTANCE_1       0
#define MODULATED_PHASE_1_ID            0x1200
#define MODULATED_PHASE_1_DESCRIPTOR    {'P','H','A','S', 'E', 'S','1','\n'}

/* Current measurements */
#define NUMBER_OF_CURRENT_SENSING   NUMBER_OF_MODULATED_PHASE

#define CURRENT_SENSING_INSTANCE_1      0
#define CURRENT_SENSING_1_ID            0x1300
#define CURRENT_SENSING_1_DESCRIPTOR    {'C','U','R','R', 'E', 'N','1','\n'}

/* Voltage measurements */
/* Phase votlage measurements */
#define NUMBER_OF_PHASE_VOLTAGE_SENSING     NUMBER_OF_MODULATED_PHASE
#define PHASE_VOLTAGE_SENSING_INSTANCE_1    0
#define PHASE_VOLTAGE_SENSING_1_ID          0x1500
#define PHASE_VOLTAGE_SENSING_1_DESCRIPTOR  {'V','O','L','T', 'A', 'G','1','\n'}

/* VBus measurements */
#define NUMBER_OF_BUS_VOLTAGE_SENSING       1
#define BUS_VOLTAGE_SENSING_INSTANCE_1      0
#define BUS_VOLTAGE_SENSING_1_ID            0x1600
#define BUS_VOLTAGE_SENSING_1_DESCRIPTOR    {'V','B','U','S', '1', '\n' ,0, 0}

/* Drive temperature */
#define NUMBER_OF_DRIVE_TEMP_SENSING        1
#define DRIVE_TEMP_SENSING_INSTANCE_1       0
#define DRIVE_TEMP_SENSING_1_ID             0x1700
#define DRIVE_TEMP_SENSING_1_DESCRIPTOR     {'T','E','M','P', 'D', '1' ,'\n', 0}

/* Uart configuration */
#define NUMBER_OF_UART   0

#define UART_INST_1         0
#define UART_1_ID           0x1100
#define UART_1_DESCRIPTOR   {'U','A','R','T', '1', '\n', 0, 0}

/* Spi configuration */
#define NUMBER_OF_SPI       1
#define SPI_INST_1          0

/* I2C configuration */
#define NUMBER_OF_I2C       1
#define I2C_INST_1          0

/* Nvm configuration */
#define NUMBER_OF_NVM       1
#define NVM_INTF            0

#define NVM_1_NODE      (uint16_t)0x51U

/** NVM passwords */
#define NVM_PASS_SIZE   (uint16_t)0x4U
#define NVM_1_PASS_ADDR (uint16_t)0x0U

#define NVM_1_PASS_1    (uint16_t)0xAD33U
#define NVM_1_PASS_2    (uint16_t)0xC0BCU
#define NVM_1_PASS_3    (uint16_t)0x62DDU
#define NVM_1_PASS_4    (uint16_t)0x8A72U

/* Available GPIO */
#define NUMBER_OF_PIN    7

#define PIN1             0
#define PIN2             1
#define PIN3             2
#define PIN4             3
#define PIN5             4
#define PIN6             5
#define PIN7             6

/* Axis parameters */
#define NUMBER_OF_AXIS  1
#define AXIS_INSTANCE_1 0
/* Current feedback type */
#define CURRENT_FEEDBACK_TYPE   0

/* Board Selft Test module */
#define NUMBER_OF_BOARD_MODULES NUMBER_OF_COPRO_CORE_1 + \
                                NUMBER_OF_UART + \
                                NUMBER_OF_MODULATED_PHASE + \
                                NUMBER_OF_CURRENT_SENSING + \
                                NUMBER_OF_ADC_INSTANCES + \
                                NUMBER_OF_PHASE_VOLTAGE_SENSING + \
                                NUMBER_OF_BUS_VOLTAGE_SENSING + \
                                NUMBER_OF_DRIVE_TEMP_SENSING

#endif
/** @} */
