/**
 * @file delfino_dual_cpu1.h
 * @brief This file provides the pin and function mappings for each
 *        rockstarcore based on delfino dual core
 *
 * @author  Firmware department
 * @copyright  Ingenia Motion Control (c) 2016. All rights reserved.
 */

/**
 * \addtogroup BoardMapping Board-MCU mapping
 *
 * @{
 */

#ifndef DELFINO_DUAL_CPU1_H
#define DELFINO_DUAL_CPU1_H

/* define math type as float(1) */
#define   MATH_TYPE      1
#include "F28x_Project.h"
#include "driverlib/sysctl.h"
#include "driverlib/interrupt.h"
#include "driverlib/uart.h"
#include "driverlib/systick.h"
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"

/* Basic board elements */
#define XTAL_FREQ 20000000
#define SYSTEM_FREQ_HZ 200000000
#define SYSTEM_FREQ_MHZ 200000000/1000000
#define PERIPHERAL_FREQ_HZ 50000000

/* Uart configuration */
#define UART1_TX_PIN        14
#define UART1_RX_PIN        15
#define UART1_TX_PIN_MAP    2
#define UART1_RX_PIN_MAP    2
#define UART1_BASE          UARTB_BASE
#define UART1_INT_ACK       PIEACK_GROUP9
#define UART1_LOOPBACK_PIN  19
#define UART1_TX_EN_PIN     12

/* Spi configuration */
#define SPI1_MOSI_PIN       63
#define SPI1_MISO_PIN       64
#define SPI1_CLK_PIN        65
#define SPI1_CS_PIN         66
#define SPI1_IRQ_PIN        82
#define SPI1_LOOPBACK_PIN   83
#define SPI1_CPU            GPIO_MUX_CPU1
#define SPI1_MOSI_PIN_MAP   15
#define SPI1_MISO_PIN_MAP   15
#define SPI1_CLK_PIN_MAP    15
#define SPI1_CS_PIN_MAP     15
#define SPI1_BASE           SPIB_BASE
#define SPI1_INT_SRC_TX     INT_SPITXINTB
#define SPI1_INT_SRC_RX     INT_SPIRXINTB
#define SPI1_INT_ACK        PIEACK_GROUP6
#define SPI1_REGS           SpibRegs

/* I2C configuration */
#define I2C1_SCL_PIN        92
#define I2C1_SDA_PIN        91
#define I2C1_SCL_PIN_MAP    6
#define I2C1_SDA_PIN_MAP    6
#define I2C1_BASE           I2CA_BASE
#define I2C1_INT_SRC        INT_I2CINT1A
#define I2C1_INT_ACK        PIEACK_GROUP8
#define I2C1_REGS           I2caRegs

/** NVM mapping */
#define NVM_WC_PIN          90

/* Pinout mapping */
#define PIN1_PIN  108
#define PIN1_PORT 3
#define PIN1_CPU  GPIO_MUX_CPU1

#define PIN2_PIN  104
#define PIN2_PORT 3
#define PIN2_CPU  GPIO_MUX_CPU1

#define PIN3_PIN  105
#define PIN3_PORT 3
#define PIN3_CPU  GPIO_MUX_CPU1

#define PIN4_PIN  106
#define PIN4_PORT 3
#define PIN4_CPU  GPIO_MUX_CPU1

#define PIN5_PIN  85
#define PIN5_PORT 2
#define PIN5_CPU  GPIO_MUX_CPU1

#define PIN6_PIN  11
#define PIN6_PORT 0
#define PIN6_CPU  GPIO_MUX_CPU1

#define PIN7_PIN  81
#define PIN7_PORT 2
#define PIN7_CPU  GPIO_MUX_CPU1

/* ADC instance mapping */
#define TEMPERATURE_SENSOR_ADC      0
#define BUS_VOLTAGE_SENSOR_ADC      0
#define PHASE_VOLTAGE_SENSOR_ADC    0
#define CURRENT_SENSOR_ADC          0

#endif /* DELFINO_DUAL_CPU1_H */

/** @} */
