/**
 * @file crc_tool.c
 *
 * @author  Firmware department
 * @copyright Ingenia Motion Control (c) 2016. All rights reserved.
 */

#include "crc_tool.h"

#include <string.h>
#include <stdbool.h>
#include "crctable0x1021.h"
#include "crctable0x97.h"

void
CRCInit(TCrcIntf* ptInst)
{
    ptInst->CRC.nMsgBytes = 0;
    ptInst->CRC.crcResult = 0;
    ptInst->CRC.pMsgBuffer = NULL;

    switch (ptInst->eType)
    {
        case CRC_CCITT_XMODEM:
            ptInst->CRC.seedValue = INIT_CRC16;
            ptInst->CRC.parity = CRC_parity_even;
            ptInst->CRC.pCrcTable = (uint16_t *)&crc16P2Table[0];
            ptInst->CRC.init = (void (*)(void *))CRC_init16Bit;
            ptInst->CRC.run = (void (*)(void *))CRC_run16BitPoly2;
            ptInst->CRC.init(&ptInst->CRC);
            break;
        case CRC_8_C2:
            ptInst->CRC.seedValue = INIT_CRC8;
            ptInst->CRC.parity = CRC_parity_even;
            ptInst->CRC.pCrcTable = (uint16_t *)&crc8TableC2[0];
            ptInst->CRC.init = (void (*)(void *))CRC_init8Bit;
            ptInst->CRC.run = (void (*)(void *))CRC_run8BitTableLookupC;
            ptInst->CRC.init(&ptInst->CRC);
            break;
        default:
            /* nothing */
            break;
    }
}

void
CRCDeinit(TCrcIntf *ptInst)
{
    ptInst->CRC.seedValue = 0;
    ptInst->CRC.nMsgBytes = 0;
    ptInst->CRC.parity = CRC_parity_even;
    ptInst->CRC.crcResult = 0;
    ptInst->CRC.pMsgBuffer = NULL;
    ptInst->CRC.pCrcTable = NULL;
    ptInst->CRC.init = NULL;
    ptInst->CRC.run = NULL;
}

uint16_t
CRCProcess(TCrcIntf* ptInst, const uint16_t *pu16Bfr, uint32_t u32Size)
{
    ptInst->CRC.nMsgBytes = u32Size;
    ptInst->CRC.crcResult = 0;
    ptInst->CRC.pMsgBuffer = (void*)pu16Bfr;

    ptInst->CRC.run(&ptInst->CRC);
    return (uint16_t)ptInst->CRC.crcResult;
}
