/**
 * @file inputouput.c
 * @brief
 *
 * @author  Firmware department
 * @copyright Ingenia Motion Control (c) 2016. All rights reserved.
 */

#include "input_output.h"
#include "board_mapping.h"
#include "board_config.h"

const uint16_t u16PinMap[NUMBER_OF_PIN] =
        { PIN1_PIN, PIN2_PIN, PIN3_PIN, PIN4_PIN, PIN5_PIN, PIN6_PIN, PIN7_PIN };

const uint16_t u16PortMap[NUMBER_OF_PIN] =
        { PIN1_PORT, PIN2_PORT, PIN3_PORT, PIN4_PORT, PIN5_PORT, PIN6_PORT, PIN7_PORT };

const uint16_t u16CPUMap[NUMBER_OF_PIN] =
        { PIN1_CPU, PIN2_CPU, PIN3_CPU, PIN4_CPU, PIN5_CPU, PIN6_CPU, PIN7_CPU };

#ifdef CPU1
void InOutConfig(uint16_t u16Pin, EInOutModes eMode)
{
    switch (eMode)
    {
        case INPUT_MODE:
            GPIO_SetupPinOptions(u16PinMap[u16Pin], GPIO_INPUT, GPIO_PUSHPULL);
            GPIO_SetupPinMux(u16PinMap[u16Pin], u16CPUMap[u16Pin], 0);
            break;
        case OUTPUT_MODE:
            GPIO_SetupPinOptions(u16PinMap[u16Pin], GPIO_OUTPUT, GPIO_PUSHPULL);
            GPIO_SetupPinMux(u16PinMap[u16Pin], u16CPUMap[u16Pin], 0);
            break;
        case INPUT_PULLUP_MODE:
            GPIO_SetupPinOptions(u16PinMap[u16Pin], GPIO_INPUT,
                                 GPIO_PUSHPULL | GPIO_PULLUP);
            GPIO_SetupPinMux(u16PinMap[u16Pin], u16CPUMap[u16Pin], 0);
            break;
        case OUTPUT_PULLUP_MODE:
            GPIO_SetupPinOptions(u16PinMap[u16Pin], GPIO_OUTPUT,
                                 GPIO_PUSHPULL | GPIO_PULLUP);
            GPIO_SetupPinMux(u16PinMap[u16Pin], u16CPUMap[u16Pin], 0);
            break;
        default:
            break;
    }
}
#endif

EInOutValue InRead(uint16_t u16Pin)
{
    return ((EInOutValue)GPIO_ReadPin(u16PinMap[u16Pin]));
}

void OutWrite(uint16_t u16Pin, EInOutValue eValue)
{
    GPIO_WritePin(u16PinMap[u16Pin], (uint16_t)eValue);
}
