/**
 * @file ticktimer.c
 * @brief
 *
 * @author  Firmware department
 * @copyright Ingenia Motion Control (c) 2016. All rights reserved.
 */

#include "tick_time.h"

#include "board_mapping.h"
#include "board_config.h"

typedef struct
{
    /** Base period in us */
    uint32_t u32Prd;
    /** Current number of ticks */
    uint32_t u32Ticks;
} TTimeHandler;

static TTimeHandler tHandler;

interrupt void SysTick(void);

void TimeInit(uint32_t u32Period)
{
    tHandler.u32Prd = u32Period;
    tHandler.u32Ticks = 0;

    SysTickIntRegister(SysTick);
    SysTickInit();
    SysTickPeriodSet(SYSTEM_FREQ_MHZ * tHandler.u32Prd);
}

void TimeStart(void)
{
    SysTickIntEnable();
    SysTickEnable();
}

uint32_t TimeGetus(void)
{
    uint32_t u32Temp = tHandler.u32Ticks;

    u32Temp *= tHandler.u32Prd;

    return (u32Temp);
}

uint32_t TimeGetms(void)
{
    uint32_t u32Temp = tHandler.u32Ticks;

    u32Temp =
            (uint32_t)((uint64_t)(u32Temp * tHandler.u32Prd) / (uint64_t)1000);

    return (u32Temp);
}

uint32_t TimeGettick(void)
{
    return tHandler.u32Ticks;
}

void TimeDelayUs(uint64_t u64MicroSeconds)
{
    DELAY_US(u64MicroSeconds);
}

interrupt void SysTick(void)
{
    tHandler.u32Ticks++;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}
