/**
 * @file ticktime.h
 * @brief This file offers a abstract layer that allows to use a reference time
 *        for a rockstarcore based drive
 *
 * @author  Firmware department
 * @copyright Ingenia Motion Control (c) 2016. All rights reserved.
 */

/**
 * \defgroup Time Time API
 *
 * @{
 */

#ifndef TICKTIME_H
#define TICKTIME_H

#include <stdint.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Initializes the Time unit with a base time of u32Period us
 *
 * @param[in] u32Period base time of the system tick in us
 */
void
TimeInit(uint32_t u32Prd);

/**
 * Starts standard operation of time unit
 */
void
TimeStart(void);

/**
 * Reads time since system is powered on in us
 */
uint32_t
TimeGetus(void);

/**
 * Reads time since system is powered on in ms
 */
uint32_t
TimeGetms(void);

/**
 * Reads time since system is powered on in MCU ticks
 */
uint32_t
TimeGettick(void);

/**
 * Blocks the thread the specified microseconds.
 *
 * @param[in] u64micros
 *  Indicates the number of microseconds
 */
void
TimeDelayUs(uint64_t u64micros);

#ifdef __cplusplus
}
#endif

#endif /* TICKTIME_H */

/** @} */
