/**
 * @boot.h
 * @brief Shared definition between boot & application
 *
 * @author  Roger Juanpere
 * @copyright Ingenia Motion Control (c) 2017. All rights reserved.
 */

#ifndef BOOT_H_
#define BOOT_H_

#include "errors.h"

typedef enum {
    /** No error */
    BOOT_OK     =            0,
    /** Generic error */
    BOOT_ERROR  = ERR_BOOT + 1,
    /** Permission denied */
    BOOT_EACCES = ERR_BOOT + 2,
    /** Invalid application */
    BOOT_EAPP   = ERR_BOOT + 3,
    /** boot mode forced by GPIO */
    BOOT_FORCED = ERR_BOOT + 4,
} BootErrorCode;

/** Address in Flash of the shared memory between boot and application */
/* TODO: Move it to linker script */
#define BOOT_SHARED_ADDRESS     (uint32_t)0xBE000
/** Address in Flash where the bootloader start */
#define BOOT_START_ADDRESS      (uint32_t)0x80000
/** Address in Flash where the bootloader end */
#define BOOT_END_ADDRESS        (uint32_t)0x83FFF
/** Address in Flash where the application start */
#define BOOT_APP_ADDRESS        (uint32_t)0x88000

#endif /* BOOT_H_ */
