/**
 * @file serial_boot.c
 *
 * @author  Firmware department
 * @copyright Ingenia Motion Control (c) 2016. All rights reserved.
 */

#include "serial_boot.h"
#include <string.h>
#include "flash_mng.h"
#include "bootloader.h"
#include "input_output.h"

#define SERIAL_BOOTSTRAP 0

#define REQUEST_OK (uint16_t)1U
#define REQUEST_KO (uint16_t)0U.

#define REQ_EEPROM_ACCESS_SIZE     0x2U

void SerialBootInit(TSerialInst *ptInst)
{
    ptInst->isRequest = false;
    ptInst->isReplySent = false;
    ptInst->isEndReceived = false;
    ptInst->isBootOpen = false;
    ptInst->isEepromOpen = false;
}

void SerialBootDeInit(TSerialInst *ptInst)
{
}

void SerialBootStart(TSerialInst *ptInst)
{
}

void SerialBootStop(TSerialInst *ptInst)
{
}

bool SerialBootProcess(TSerialInst *ptInst, uint32_t* pu32Address)
{
    int32_t i32Error;
    uint32_t u32Add;

    if (ptInst->isRequest != false)
    {
        switch (ptInst->tReply.u16Address)
        {
            case BOOT_CMD_OPEN:
#if defined(CPU1)
                    i32Error = BootEraseSignature();

                    if (i32Error < 0)
                    {
                        ptInst->isBootOpen = false;
                    }
                    else
#endif
                    {
                        ptInst->isBootOpen = true;
                    }
                break;
            case BOOT_CMD_ERASE:
                if (ptInst->isBootOpen != false)
                {
                   BootErase(u32Add);
                }
                break;

            case BOOT_CMD_WRITE:
                if (ptInst->isBootOpen != false)
                {
                    i32Error = BootWrite(u32Add, &ptInst->tRequest.u16Data[BOOT_WRITE_DATA_IDX],
                                         ptInst->tRequest.u16Size - (BOOT_WRITE_DATA_IDX));
                }
                break;

            case BOOT_CMD_CLOSE:
                if (ptInst->isBootOpen != false)
                {
                    /** Write access */
                    BootGetAppAddress(pu32Address);
                }
                break;
            default:
                break;
        }

        ptInst->isRequest = false;
    }

    return (ptInst->isEndReceived && ptInst->isReplySent);
}

