/**
 * @file serial_config.h
 * @brief This file is used to configure the serial protocol capabilities
 *
 * @author  Firmware department
 * @copyright Ingenia Motion Control (c) 2016. All rights reserved.
 */

/**
 * \addtogroup Serial
 *
 * @{
 *
 */

/**
 * \addtogroup SConfig Serial Configuration
 *
 * @{
 *
 *  Serial configuration parameters and helpful mask for header processing
 */

#ifndef SERIAL_CONFIG_H
#define SERIAL_CONFIG_H

#include "stdint_ex.h"

/** Number of available physical interfaces */
#define SERIAL_PORT_INTERFACES 2

/* This buffer must be < 256 */
/** Max serial buffer size */
#define SERIAL_BUFFER_SIZE  192
/** Max daata field size */
#define SERIAL_DATA_SIZE    128

/* Header bits description */
/* Frame type */
/** EMCY frame type */
#define EMCY_TYPE 0x00U
/** NMT frame type */
#define NMT_TYPE  0x01U
/** PDO frame type */
#define PDO_TYPE  0x02U
/** SDO frame type */
#define SDO_TYPE  0x03U

/* Address type */
/** Broadcast access */
#define ADDRESS_BRD    0x00U
/** Access through scan address */
#define ADDRESS_SCAN   0x04U
/** Access through user address */
#define ADDRESS_USER   0x08U

/* Access type */
/** Undefined access type */
#define SERIAL_BRD     0x00U
/** Read access type */
#define SERIAL_READ    0x10U
/** Write access type */
#define SERIAL_WRITE   0x20U
/** Acknowledge access type */
#define SERIAL_ACK     0x30U

/* Abort flag */
/** Abort flag unactive */
#define ABORT_UNACTIVE  0x00U
/** Abort flag active */
#define ABORT_ACTIVE    0x40U

/* Scanning flag */
/** Scanning flag disabled */
#define SCAN_DISABLED  0x00U
/** Scanning flag enabled */
#define SCAN_ENABLED   0x80U

/* Header masks */
/* Read mask */
/** Mask for reading frame type from header */
#define FRAME_TYPE_READMASK      0x03U
/** Mask for reading address type from header */
#define ADDRESS_TYPE_READMASK    0x0CU
/** Mask for reading access type from header */
#define ACCESS_TYPE_READMASK     0x30U
/** Mask for reading abort flag from header */
#define ABORT_FLAG_READMASK      0x40U
/** Mask for reading scanning flag from header */
#define SCANNING_FLAG_READMASK   0x80U
/* Write mask */
/** Mask for writting frame type from header */
#define FRAME_TYPE_WRITEMASK     0xFCU
/** Mask for writting address type from header */
#define ADDRESS_TYPE_WRITEMASK   0xF3U
/** Mask for writting access type from header */
#define ACCESS_TYPE_WRITEMASK    0xCFU
/** Mask for writting abort flag from header */
#define ABORT_FLAG_WRITEMASK     0xBFU
/** Mask for writting scanning flag from header */
#define SCANNING_FLAG_WRITEMASK  0x7FU

#endif /* SERIAL_CONFIG_H */

/** @} */
/** @} */
