/**
 * @file main.c
 *
 * @author  Firmware department
 * @copyright Ingenia Motion Control (c) 2016. All rights reserved.
 */

#include <string.h>
#include <stdbool.h>
#include "board_config.h"
#include "board_mapping.h"
#include "board.h"
#include "input_output.h"
#include "communications/serial_boot.h"
#include "flash_mng.h"
#include "bootloader.h"

/* Static Functions ----------------------------------------------------------*/
static void SystemInit(TSerialInst* pSerial);
static void SystemStart(TSerialInst* pSerial);
static bool SystemLoop(TSerialInst* pSerial, uint32_t* pu32Address);

/* Functions -----------------------------------------------------------------*/
uint32_t main(void)
{
    uint32_t u32Address;
    TSerialInst Serial;

    /* HW initialization */
    SystemInit(&Serial);

    BoardBootInit();
    /* Launch the application */
    SystemStart(&Serial);

    while (SystemLoop(&Serial, &u32Address) == false);
#if defined(CPU1)
    BoardSetCPUMapping();
#endif
    BoardStartOtherCPU();
#if defined(CPU1)
    BootSetSignature();
    BoardReset();
#endif

    return (u32Address);
}

static void
SystemInit(TSerialInst* pSerial)
{
    BoardInit();

    SerialBootInit(pSerial);
}

static void
SystemStart(TSerialInst* pSerial)
{
    SerialBootStart(pSerial);
}

static bool
SystemLoop(TSerialInst* pSerial, uint32_t* pu32Address)
{
    return SerialBootProcess(pSerial, pu32Address);
}
