
#include "DSP28_Device.h"
void mailbox_check(int32 T1,int32 T2,int32 T3);
void mailbox_read(int16 i);

//Global variable for this example
Uint32 ErrorCount;
Uint32 MessageReceiveCount;
unsigned char sendCommand;
extern Uint32 TestMbox1;
extern Uint32 TestMbox2;
extern Uint32 TestMbox3;

void main(void)
{
	Uint16 j;
	/*ʼϵͳ*/
	InitSysCtrl();

	/*ж*/
	DINT;
	IER = 0x0000;
	IFR = 0x0000;

	/*ʼPIEж*/
	InitPieCtrl();

	/*ʼPIEжʸ*/
	InitPieVectTable();	
	
	/*ʼSCIAĴ*/
    InitECan();
	
	MessageReceiveCount = 0;
	ErrorCount = 0;
    
    #if CAN_INT
	/*жϷڵַ*/
	EALLOW;	// This is needed to write to EALLOW protected registers
	PieVectTable.ECAN0INTA = &ECAN0INTA_ISR;
	PieVectTable.ECAN1INTA = &ECAN1INTA_ISR;
	EDIS;   // This is needed to disable write to EALLOW protected registers

	/*ж*/
	IER |= M_INT9;
	#endif
	EINT;   // Enable Global interrupt INTM
	ERTM;	// Enable Global realtime interrupt DBGM
	sendCommand = 1;
	for(;;)
	{
		
		
		if(sendCommand == 1) {		
			
			ECanaRegs.CANTRS.all = 0x0000FFFF;
			//while(ECanaRegs.CANTA.all != 0x0000FFFF);
			while(ECanaRegs.CANTA.all != 0x00000001);
			ECanaRegs.CANTA.all = 0x0000FFFF;
			MessageReceiveCount++;
			//for(j = 0; j < 0x1000; j++);
	
		
			#if !CAN_INT
			for(j = 16; j < 32; j++)
			{
				mailbox_read(j);
				//mailbox_read(1);
			//	mailbox_check(TestMbox1,TestMbox2,TestMbox3);
			}
			#endif
			
		//	sendCommand = 0;
		}
	}

} 	

void mailbox_read(int16 MBXnbr)
{
   volatile struct MBOX *Mailbox;
   while( ECanaRegs.CANRMP.bit.RMP16 == 0 ) ; //Wait for all RMPn to be set
   ECanaRegs.CANRMP.all = 0x00010000;
   Mailbox = &ECanaMboxes.MBOX0 + MBXnbr;
   TestMbox1 = Mailbox->MDL.all; // = 0x9555AAAn (n is the MBX number)
   TestMbox2 = Mailbox->MDH.all; // = 0x89ABCDEF (a constant)
   TestMbox3 = Mailbox->MSGID.all;// = 0x9555AAAn (n is the MBX number)

} // MSGID of a rcv MBX is transmitted as the MDL data.


void mailbox_check(int32 T1, int32 T2, int32 T3)
{
    if((T1 != T3) || ( T2 != 0x89ABCDEF))
    {
       ErrorCount++;
    }
}
//===========================================================================
// No more.
//===========================================================================
