//###########################################################################
//
// FILE:   CLAACCESS-IRQ.c
//
// TITLE:  CLAACCESS Project Specific Interrupt Service Routines
//
//###########################################################################

//#include "F2807x_device.h"       // F2807x Header File Include File
//#include "F2807x_Examples.h"     // F2807x Examples Include File
#include "F28x_Project.h"

int IRQTrace = 0x01;
int TestValue = 0xff;

//---------------------------------------------------------------------------
// 1.1 - ADCA Interrupt 1, project specific for CLAACCESS
interrupt void CLAACCESS_ADCA1_ISR(void)
{
	static int toggle = 0;

    // Insert ISR Code here
	// test pin
	if( IRQTrace & 0x1 )
	{
		toggle = 1 - toggle;
		GPIO_WritePin(89, toggle);
	}

    // Clear INT flag for this irq
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //clear INT1 flag
	PieCtrlRegs.PIEIFR1.bit.INTx1 = 0;

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    //asm ("      ESTOP0");
    //for(;;);
}

// 1.2 - ADCB Interrupt 1, project specific for CLAACCESS
interrupt void CLAACCESS_ADCB1_ISR(void)
{
    // Insert ISR Code here
	static int toggle = 0;

    // Insert ISR Code here
	// test pin
	if( IRQTrace & 0x2 )
	{
		toggle = 1 - toggle;
		GPIO_WritePin(89, toggle);
	}

    // Clear INT flag for this irq
	AdcbRegs.ADCINTFLGCLR.bit.ADCINT2 = 1; //clear INT2 flag

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    //asm ("      ESTOP0");
    //for(;;);
}

// 2.3 - ePWM3 Trip Zone Interrupt, project specific for CLAACCESS
interrupt void CLAACCESS_EPWM3_TZ_ISR(void)
{
/*
    // set test point
    GpioDataRegs.GPASET.bit.GPIO22 = 1;

    // HW PWM enable monoflop trigger
    GpioDataRegs.GPBSET.bit.GPIO33 = 1;

    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// Must acknowledge the PIE group

    // Clear PWM INT flag
    EPwm3Regs.ETCLR.bit.INT = 1;

    // HW PWM enable monoflop trigger
    GpioDataRegs.GPBCLEAR.bit.GPIO33 = 1;

    // toggle test point
    GpioDataRegs.GPACLEAR.bit.GPIO22 = 1;
*/
}

// 3.4 - ePWM4 Interrupt, project specific for CLAACCESS
interrupt void CLAACCESS_EPWM4_ISR(void)
{
    // Insert ISR Code here
	static int toggle = 0;

    // Insert ISR Code here
    // TODO Just for test
	// Cla1ForceTask1();

	// test pin
	if( IRQTrace & 0x4 )
	{
		toggle = 1 - toggle;
		GPIO_WritePin(89, toggle);
	}

	TestValue = EPwm4Regs.ETFLG.bit.SOCA;	// Test, if the SOCA event arrived.

    // Clear INT flag for this timer
    EPwm4Regs.ETCLR.bit.INT = 1;

	TestValue = EPwm4Regs.ETFLG.bit.SOCA;	// Test, if the SOCA event arrived.


    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    //asm ("      ESTOP0");
    //for(;;);
}
