//###########################################################################
//
// FILE:   CLAACCESS-IRQ.h
//
// TITLE:  CLAACCESS Project Specific Interrupt Service Routines Definitions
//

#ifndef CLAACCESS_IRQ_H
#define CLAACCESS_IRQ_H
#ifdef __cplusplus
extern "C" {
#endif

//---------------------------------------------------------------------------
// Default Interrupt Service Routine Declarations can be found in F2807x_defaultisr.h
// The following function prototypes are for the
// project specific ISR routines used with the project specific PIE vector table.
// The project specific vector table is found in the F2807x_pievect.h
// file.
interrupt void CLAACCESS_ADCA1_ISR(void);                       // 1.1 - ADCA Interrupt 1
interrupt void CLAACCESS_ADCB1_ISR(void);                       // 1.2 - ADCB Interrupt 1
interrupt void CLAACCESS_EPWM3_TZ_ISR(void);                    // 2.3 - ePWM3 Trip Zone Interrupt
interrupt void CLAACCESS_EPWM4_ISR(void);                       // 3.4 - ePWM4 Interrupt
#ifdef __cplusplus
}
#endif                                                /* extern "C" */


#endif                                                // end of F2807x_PIEVECT_H definition
//===========================================================================
// End of file.
//===========================================================================
