//============================================================================
//	FILE:			CLAACCESS-Main.C
//
//	Description:
//
//  Target:  		TMS320F28075(Piccolo),
//
//============================================================================
// Include files for device support, F2807x in this case
//============================================================================

//#include "F2807x_device.h"     // Headerfile Include File
//#include "F2807x_settings.h"   // Settings Include File
#include <CLAACCESS-Shared_C.h>
#include "F28x_Project.h"
#include "F2807x_defaultisr.h"

//============================================================================
// macros, definitions
//============================================================================

//============================================================================
// FUNCTION PROTOTYPES
//============================================================================

extern void DeviceInit(void);

//============================================================================
// VARIABLE DECLARATIONS - GENERAL
//============================================================================

/**
 * @brief Main function
 * @author: Gyula Kiss @ Siemens PSE
 * @param  None
 * @retval None
 */
void main(void)
{
	int toggle = 0;
	int toggle2 = 0;
    EnableFlag = 0;
    long Testvalue = 0x0;
    long Test_ADCREGREAD = 0x0;
    long Test_PWMREGREAD = 0x0;
    long Test_varCLA2 = 0x0;
    long Test_varCLA3 = 0x0;
    long Test_varCLA4 = 0x0;


	DeviceInit();	// Device Life support & GPIO

	// init hardware monitor
    //SetupHWMon();

	Testvalue = vSense_Raw;	// Testing init value

	// Reading out actual silicon partid/revision id registers. Actual data in comment:
	Testvalue = DevCfgRegs.PARTIDH.all; //Testvalue	long	0x00FF0500 (Hex)	0x0000040E@Data
	Testvalue = DevCfgRegs.PARTIDL.all; //Testvalue	long	0x0007FD0A (Hex)	0x0000040E@Data
	Testvalue = DevCfgRegs.REVID; //Testvalue	long	0x00000002 (Hex)	0x0000040E@Data


	for (;;)
	{
		// infinite loop
		if (CpuTimer1Regs.TCR.bit.TIF == 1)
		{
			CpuTimer1Regs.TCR.bit.TIF = 1;

		    // CPU blink LED
			toggle = 1 - toggle;
			GPIO_WritePin(84, toggle);
			AdcaRegs.ADCINTOVFCLR.bit.ADCINT1 = 1;
			iRef_Raw = 0xa55a;	// Testing CPU-CLA-CPU communication

        }

		if (CpuTimer2Regs.TCR.bit.TIF == 1)
		{
			CpuTimer2Regs.TCR.bit.TIF = 1;

			// TODO test
			// Cla1ForceTask1();
			toggle2 = 1 - toggle2;
			 GPIO_WritePin(3, toggle2);
			 Testvalue = vSense_Raw;	// Testing CPU-CLA-CPU Communication, iRef_Raw is routed back to vSense_Raw in CLATask4: OK!
			 Test_ADCREGREAD = vRect_Raw; // Testing ADC result register access. : OK! (0x904)
			 Test_PWMREGREAD = PWM_Raw;// TEsting EPWM Periph register access. : NOT OK! ==> Shall be 0x0083, IS: 0x0: NOT OK
			 Test_varCLA2=CLA_iRefTest; // PWM Register access, Shall be 125/1300, IS:0: NOT OK!
			 Test_varCLA3=CLA_iPreTest; // Variable Counter in CLA, incrementing, communication: OK
			 Test_varCLA4=CLA_iSenseTest; /// PWM Register access, shall be 125, IS:0: NOT OK!

        }
	}
}

//===========================================================================
// End of file.
//===========================================================================
