#ifndef CLASHARED_C_H_
#define CLASHARED_C_H_

//============================================================================
// definitions
//============================================================================

//============================================================================
// turn/off control segments
//============================================================================

/*#define ENABLE_VOLTAGE_MODE_CHANGE 0
#define FORCE_CURRENT_MODE 1
#define FORCE_VOLTAGE_MODE 0
#define VOLTAGE_CONTROL_LOOP 1
#define INPUT_VOLTAGE_CORRECTION 0
#define SOFT_START_CONTROL 1
#define FEED_FORWARD_IN_CLA 1
#define FEED_FORWARD_SIGNAL_IRQ (1-FEED_FORWARD_IN_CLA)
#define ENABLE_CONTROL_SIGNAL_TO_CLA 1
*/
// set if isense in CLA scled in runtime
#define ISENSE_GAIN_ADJUSTABLE 0

// set for safe operation, but signals can be observed
#define SIGNAL_TEST_MODE 0

// set if cla trace is required
#define USE_CLA_TRACE 1

//============================================================================
// scaling definitions
//============================================================================

// output pwm period
// 250 kHz
#define PWM_PERIOD 400

// the same as CLA period i.e. ADC EOC triggers CLA execution
// 200 kHz
#define ADC_PERIOD 250

// PWM low / high limit
#define PWM_MARGIN_HIGH 20
#define PWM_MARGIN_LOW 0

// dead time control delays
#define RISING_EDGE_DELAY 15
#define FALLING_EDGE_DELAY 10

// CPU task period
// voltage feedback, current command, etc.
// 30 kHz
//#define IRQ_TASK_PERIOD 1980
// 60kHz
#define IRQ_TASK_PERIOD 1500

// ADC : end of scale
#define ADC_MAX 4095

// CLA end of scale to PWM scaling
#define CLA_TO_PWM_SCALING ((float)(ADC_MAX / PWM_PERIOD))

// convert 12bit ADC value to IQ24
#define ADC_SCALING(a) (a<<12)

// convert IQ(24) to CLA Raw
#define CLA_SCALING(a) (a>>12)

// convert IQ(24) to HWMON signal
#define IQ_TO_HWMON(a) ((a>>13))

// convert CLA float to HWMON signal
// CLA range: 0-4095, HWMON range: 0-2047
#define CLA_TO_HWMON(a) (a>>2)

#define IQ_CONTROL_RANGE_MAX _IQ(0.9999)

// feedback signal scalings
#define VSENSE_SCALING_CLA 1.5
#define VRECT_SCALING_CLA 3.0
#define ISENSE_SCALING_CLA 1.0

// scaling feedback signals
#define VSENSE_SCALING _IQ(VSENSE_SCALING_CLA)
#define VRECT_SCALING _IQ(VRECT_SCALING_CLA)
#define ISENSE_SCALING _IQ(ISENSE_SCALING_CLA)

#define TURNS_RATIO_CLA 4.2
#define TURNS_RATIO _IQ(TURNS_RATIO_CLA)

#define FEED_FORWARD_VSENSE_PRE_SCALING (VSENSE_SCALING_CLA * TURNS_RATIO_CLA)

//============================================================================
// type definitions
//============================================================================

#ifndef DSP28_DATA_TYPES
#define DSP28_DATA_TYPES
typedef int             	int16;
typedef long            	int32;
typedef long 				int64;
typedef unsigned int    	Uint16;
typedef unsigned long   	Uint32;
typedef unsigned long 		Uint64;
typedef float           	float32;
typedef long double     	float64;
#endif

#ifndef true
#define true 1
#endif
#ifndef false
#define false 0
#endif

//============================================================================
// macro definitions
//============================================================================

#define LIMIT(a, low, high) \
        if (a > high) \
            a = high; \
        else if (a < low) \
            a = low

#define MIN(a, b) (a<=b?a:b)
#define MAX(a, b) (a>=b?a:b)

#ifdef __TMS320C28XX__
#define C28x_volatile volatile
#else
#define C28x_volatile
#endif

//============================================================================
// definitions
//============================================================================

/**
 * ADC trigger-source definitions.
 */
#define ADCTRIG_SOFT		0
#define ADCTRIG_CPU_TINT0	1
#define ADCTRIG_CPU_TINT1	2
#define ADCTRIG_CPU_TINT2	3
#define ADCTRIG_XINT2		4
#define ADCTRIG_EPWM1_SOCA	5
#define ADCTRIG_EPWM1_SOCB	6
#define ADCTRIG_EPWM2_SOCA	7
#define ADCTRIG_EPWM2_SOCB	8
#define ADCTRIG_EPWM3_SOCA	9
#define ADCTRIG_EPWM3_SOCB	10
#define ADCTRIG_EPWM4_SOCA	11
#define ADCTRIG_EPWM4_SOCB	12
#define ADCTRIG_EPWM5_SOCA	13
#define ADCTRIG_EPWM5_SOCB	14
#define ADCTRIG_EPWM6_SOCA	15
#define ADCTRIG_EPWM6_SOCB	16
#define ADCTRIG_EPWM7_SOCA	17
#define ADCTRIG_EPWM7_SOCB	18
#define ADCTRIG_EPWM8_SOCA	17
#define ADCTRIG_EPWM8_SOCB	18
#define ADCTRIG_EPWM9_SOCA	19
#define ADCTRIG_EPWM9_SOCB	20
#define ADCTRIG_EPWM10_SOCA	21
#define ADCTRIG_EPWM10_SOCB	22
#define ADCTRIG_EPWM11_SOCA	23
#define ADCTRIG_EPWM11_SOCB	24
#define ADCTRIG_EPWM12_SOCA	25
#define ADCTRIG_EPWM12_SOCB	26

// Timer definitions based on System Clock
// TODO: set for device clock!
	#define      mSec0_5          30000           // 0.5 mS
	#define      mSec0_75         45000           // 0.75 mS
	#define      mSec1            60000           // 1.0 mS
	#define      mSec2            120000          // 2.0 mS
	#define      mSec5            300000          // 5.0 mS
	#define      mSec7_5          450000          // 7.5 mS
	#define      mSec10           600000          // 10 mS
	#define      mSec20           1200000         // 20 mS
	#define      mSec50           3000000         // 50 mS
	#define      mSec75           4500000         // 75 mS
	#define      mSec100          6000000         // 100 mS
	#define      mSec200          12000000        // 200 mS
	#define      mSec500          30000000        // 500 mS
	#define      mSec750          45000000        // 750 mS
	#define      mSec1000         60000000        // 1000 mS
	#define      mSec2000         120000000       // 2000 mS
	#define      mSec5000         300000000       // 5000 mS

/*------------------------------------------------------------------------------
 Following is the list of the Build Level choices.
 ------------------------------------------------------------------------------*/
#define LEVEL1  1      		// Module check out (do not connect the motors)

#define LEVEL2  2           // Verify ADC, park/clarke, calibrate the offset

#define LEVEL3  3           // Verify closed current(torque) loop and PIDs and speed measurement

#define LEVEL4  4           // Verify speed estimation and rotor position est.

#define LEVEL5  5           // Verify close speed loop sensorless


/*------------------------------------------------------------------------------
 This line sets the BUILDLEVEL to one of the available choices.
 ------------------------------------------------------------------------------*/

#define DMC_CLA_BUILDLEVEL LEVEL3
#define SW_SCALING_TEST 0

//============================================================================
// CLA C Tasks defined in Cla1Tasks_C.cla
//============================================================================

__interrupt void Cla1Prog();
__interrupt void Cla1Task1();
//__interrupt void Cla1Task2();
//__interrupt void Cla1Task3();
__interrupt void Cla1Task4();
//__interrupt void Cla1Task5();
//__interrupt void Cla1Task6();
//__interrupt void Cla1Task7();
//__interrupt void Cla1Task8();

//============================================================================
// Task 1 (C) Variables
//============================================================================

extern volatile long iRef_Raw;
extern volatile long vRef_Raw;
extern volatile long xPre_Raw;

extern volatile float Kip_CLA;
extern volatile float Kifb_CLA;
extern volatile float Kif_CLA;
extern volatile float xPreCorr_CLA;
extern volatile long PwmTest_CLA;

extern volatile long EnableFlag;
extern volatile long VoltageMode_CLA;
extern volatile long PwmTestMonoflop;
extern volatile short PwmTestPwm;

extern volatile long iSense_Raw;
extern volatile long vSense_Raw;
extern volatile long vRect_Raw;
extern volatile long PWM_Raw;

extern volatile long CLA_iRefTest;
extern volatile long CLA_iSenseTest;
extern volatile long CLA_iPreTest;
extern volatile long CLA_iCtrlTest;

extern volatile float CLA_tmpTest;
extern volatile long CLA_Test1;
extern volatile long CLA_Test2;
extern volatile long CLA_Test3;

//Task 2 (C) Variables

//Task 3 (C) Variables

//Task 4 (C) Variables

//Task 5 (C) Variables

//Task 6 (C) Variables

//Task 7 (C) Variables

//Task 8 (C) Variables

//Common (C) Variables

#endif /*CLASHARED_C_H_*/

//===========================================================================
// End of file.
//===========================================================================
