
#include "DSP28x_Project.h"


#define C28_FREQ    150         //CPU frequency in MHz

void SignOfLife(void);


#ifdef _FLASH
// These are defined by the linker (see device linker command file)
extern Uint16 RamfuncsLoadStart;
extern Uint16 RamfuncsLoadSize;
extern Uint16 RamfuncsRunStart;
#endif


Uint16 myVar[2] = {1,2}; // at run time this global contains all zeros


void main(void)
{

    InitSysCtrl();

#ifdef _FLASH
    memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (size_t)&RamfuncsLoadSize);
    InitFlash();
#endif

    InitGpio(); // init gpio to default state
    EALLOW;
    LED_0_DIR_REG = 1;
    EDIS;
    DINT;
    InitPieCtrl(); // init pie to default state
    IER = 0x0000;
    IFR = 0x0000;
    InitPieVectTable(); // put the pie vector table in a known state

    for(;;)
    {
    	SignOfLife();


    }
}

void SignOfLife(void)
{
	unsigned long delay;

    // Turn on LED
   	LED_0_DAT_REG = 0;
   	GpioDataRegs.GPASET.bit.GPIO12 = 1;
    // Delay for a bit.
    for(delay = 0; delay < 2000000; delay++) { }
    // Turn off LED
    LED_0_DAT_REG = 1;
    GpioDataRegs.GPACLEAR.bit.GPIO12 = 1;
    // Delay for a bit.
    for(delay = 0; delay < 2000000; delay++) { }
}
