//###########################################################################
//
// FILE:   Example_2806xECanBack2Back.c
//
// TITLE:  eCAN back to back Example
//
//! \addtogroup f2806x_example_list
//! <h1>eCAN back to back (ecan_back2back)</h1>
//!
//! This example tests eCAN by transmitting data back-to-back at high speed
//! without stopping. The received data is verified. Any error is flagged.
//! MBX0 transmits to MBX16, MBX1 transmits to MBX17 and so on....
//!
//! This example uses the self-test mode of the CAN module. i.e. the
//! transmission/reception happens within the module itself (even the required
//! ACKnowldege is generated internally in the module). Therefore, there is no
//! need for a CAN transceiver to run this particular test case and no activity
//! will be seen in the CAN pins/bus. Because everything is internal, there is
//! no need for a 120-ohm termination resistor. Note that a real-world CAN
//! application needs a CAN transceiver and termination resistors on both ends
//! of the bus.
//!
//! \b Watch \b Variables \n
//! - PassCount
//! - ErrorCount
//! - MessageReceivedCount
//
//
//###########################################################################
// $TI Release:  $
// $Release Date:  $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

//
// Function Prototypes
//
void mailbox_check(int32 T1, int32 T2, int32 T3);
void mailbox_read(int16 i, int16 j);

//
// Globals
//
Uint32  ErrorCount;
Uint32  PassCount;
Uint32  MessageReceivedCount;

Uint32  TestMbox1 = 0;
Uint32  TestMbox2 = 0;
Uint32  TestMbox3 = 0;
Uint32  TestMbox4 = 0;
Uint32  TestMbox5 = 0;
Uint32  TestMbox6 = 0;

//Customer setting
#define REC_MBOX31_MSGID_ID        0x784UL
#define REC_MBOX31_LOCAL_FILTER    0x0003FFFF
#define REC_MBOX30_MSGID_ID        0x7DFUL
#define REC_MBOX30_LOCAL_FILTER    0x0003FFFF

#define REC_MBOX_LAM_LAMI         0x80000000UL
#define REC_MBOX_MSGID_AME        0x00000000UL  //without mask

//customer setting

#define REC_MBOX30_LAM_REG        ((REC_MBOX30_LOCAL_FILTER)&0x1FFFFFFF | REC_MBOX_LAM_LAMI)
#define REC_MBOX30_MSGID_REG      ((REC_MBOX30_MSGID_ID<<18)&0x1FFFFFFF | REC_MBOX_MSGID_AME)

#define REC_MBOX31_LAM_REG        ((REC_MBOX31_LOCAL_FILTER)&0x1FFFFFFF | REC_MBOX_LAM_LAMI)
#define REC_MBOX31_MSGID_REG      ((REC_MBOX31_MSGID_ID<<18)&0x1FFFFFFF | REC_MBOX_MSGID_AME)

#define test1      ((0x785<<18)&0x1FFFFFFF | REC_MBOX_MSGID_AME)
#define test2      ((0x786<<18)&0x1FFFFFFF | REC_MBOX_MSGID_AME)

//Customer setting

//
// Main
//
void main(void)
{
    Uint16 a,b ;
    Uint16 c=0,d=0;

    struct ECAN_REGS ECanaShadow;

    InitSysCtrl();

    InitECanGpio();

    DINT;

    InitPieCtrl();

    IER = 0x0000;
    IFR = 0x0000;

    InitPieVectTable();

    MessageReceivedCount = 0;
    ErrorCount = 0;
    PassCount = 0;

    InitECana();            // Initialize eCAN-A module

    ECanaMboxes.MBOX13.MSGID.all = REC_MBOX30_MSGID_REG;
    ECanaMboxes.MBOX15.MSGID.all = REC_MBOX31_MSGID_REG;

    //customer setting
    ECanaMboxes.MBOX30.MSGID.all = REC_MBOX30_MSGID_REG;
    ECanaMboxes.MBOX31.MSGID.all = REC_MBOX31_MSGID_REG;
//    ECanaLAMRegs.LAM30.all = REC_MBOX30_LAM_REG;
//    ECanaLAMRegs.LAM31.all = REC_MBOX31_LAM_REG;

    ECanaRegs.CANTA.all = 0xFFFFFFFF;    // Clear all TAn bits
    ECanaRegs.CANRMP.all = 0xFFFFFFFF;   // Clear all RMPn bits

    ECanaRegs.CANGIF0.all = 0xFFFFFFFF;  // Clear all interrupt flag bits
    ECanaRegs.CANGIF1.all = 0xFFFFFFFF;

    ECanaRegs.CANOPC.all  = 0xC0000000;  //change

    ECanaRegs.CANMD.all = 0xC0000000;//CHANGE
    ECanaShadow.CANMD.all = ECanaRegs.CANMD.all;
    ECanaRegs.CANGIM.all = 0x00000000;
    //customer setting

    ECanaMboxes.MBOX13.MSGCTRL.bit.DLC = 8;
    ECanaMboxes.MBOX15.MSGCTRL.bit.DLC = 8;

    ECanaMboxes.MBOX13.MDL.all = 0x22222222;
    ECanaMboxes.MBOX13.MDH.all = 0x22334455;

    ECanaMboxes.MBOX15.MDL.all = 0x99999999;
    ECanaMboxes.MBOX15.MDH.all = 0x99887766;

    EALLOW;


    ECanaRegs.CANMIM.all = 0x00000000;

    ECanaShadow.CANMC.all = ECanaRegs.CANMC.all;
    ECanaShadow.CANMC.bit.STM = 1;    // Configure CAN for self-test mode
    ECanaRegs.CANMC.all = ECanaShadow.CANMC.all;
    EDIS;


    ECanaRegs.CANME.all = 0xC000A000;
    ECanaShadow.CANME.all = ECanaRegs.CANME.all;


    //
    // Begin transmitting
    for(;;)
    {
        //
        // Set TRS for all transmit mailboxes
        //
//        ECanaRegs.CANRMP.all = 0xC0000000;
        ECanaRegs.CANTRS.all = 0xC000A000;
        
        while(ECanaRegs.CANTA.all != 0x0000A000 )
        {


        }

//        ECanaRegs.CANRMP.bit.RMP30 =0xC0000000;
        ECanaRegs.CANTA.all = 0x0000A000;

        a=30;
        b=31;

        mailbox_read(a,b);

    }
}

//
// mailbox_read - This function reads out the contents of the indicated
// by the Mailbox number (MBXnbr). MSGID of a rcv MBX is transmitted as the 
// MDL data.
//
void
mailbox_read(int16 MBXnbr1, int16 MBXnbr2)
{
    volatile struct MBOX *Mailbox;
    Mailbox = &ECanaMboxes.MBOX0 + MBXnbr1;
    TestMbox1 = Mailbox->MDL.all;   // = 0x9555AAAn (n is the MBX number)
    TestMbox2 = Mailbox->MDH.all;   // = 0x89ABCDEF (a constant)
    TestMbox3 = Mailbox->MSGID.all; // = 0x9555AAAn (n is the MBX number)
    Mailbox = &ECanaMboxes.MBOX0 + MBXnbr2;
    TestMbox4 = Mailbox->MDL.all;   // = 0x9555AAAn (n is the MBX number)
    TestMbox5 = Mailbox->MDH.all;   // = 0x89ABCDEF (a constant)
    TestMbox6 = Mailbox->MSGID.all; // = 0x9555AAAn (n is the MBX number)

} 

//
// mailbox_check - 
//
void
mailbox_check(int32 T1, int32 T2, int32 T3)
{
    if((T1 != T3) || ( T2 != 0x89ABCDEF))
    {
        ErrorCount++;
    }
    else
    {
        PassCount++;
    }
}

//
// End of File
//

