#ifndef EPWM_MANAGEMENT_H_
#define EPWM_MANAGEMENT_H_

//! \b External \b Connections \n
//! - GPIO0 EPWM1A - PIN 40
//! - GPIO1 EPWM1B - PIN 39
//! - GPIO2 EPWM2A - PIN 38
//! - GPIO3 EPWM2B - PIN 37
//! - GPIO4 EPWM3A - PIN 36
//! - GPIO5 EPWM3B - PIN 35

// includes
#include "driverlib.h"
#include "device.h"
#include "epwm.h"

//define
#define EPWM_TIMER_TBPRD        1250U       //pi basso il numero, pi alta la frequenza
                                            //(1000U = 25kHz, 1250U = 20kHz, 2000U = 12.5kHz)
#define EPWM_TIMER_CONST        1250        //deve essere uguale a quello sopra senza la U
#define DEADTIME                65          //65 per 1.3 us, 130 per 2.6 us


//prototypes
void setupEPWM();

void initEPWMWithoutDB(uint32_t base);

void initEPWMGPIO(void);

void setupEPWMActiveHighComplementary(uint32_t base);

void setDutyCyclePercent(uint32_t base, int percent);

void setDutyCycleValue(uint32_t base, int value);

uint16_t convertPercent(int perc); //passa da percentuale (0-100) a parametro epwm max (0-1000)

#endif
