//#############################################################################
//
// FILE:   empty_bitfield_driverlib_main.c
//
// TITLE:  Empty Example
//
// Empty Bit-Field & Driverlib Example
//
// This example is an empty project setup for Bit-Field and Driverlib 
// development.
//
//#############################################################################
// $TI Release: F2837xD Support Library v3.10.00.00 $
// $Release Date: Tue May 26 17:13:46 IST 2020 $
// $Copyright:
// Copyright (C) 2013-2020 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//#############################################################################

//
// Included Files
//
#include "main.h"

//
// Main
//
void main(void)
{
    // Initialize System Control:
    // PLL, WatchDog, enable Peripheral Clocks
    // This example function is found in the F2837xD_SysCtrl.c file.
        InitSysCtrl();
    // Step 3. Clear all interrupts and initialize PIE vector table:
    // Disable CPU interrupts
        DINT;

    // Initialize the PIE control registers to their default state.
    // The default state is all PIE interrupts disabled and flags
    // are cleared.
    // This function is found in the F2837xD_PieCtrl.c file.
        InitPieCtrl();

    // Disable CPU interrupts and clear all CPU interrupt flags:
        IER = 0x0000;
        IFR = 0x0000;

    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    // This will populate the entire table, even if the interrupt
    // is not used in this example.  This is useful for debug purposes.
    // The shell ISR routines are found in F2837xD_DefaultIsr.c.
    // This function is found in F2837xD_PieVect.c.
        InitPieVectTable();

    //Initialization routine for endat operation - defined in endat.c
    //Configures the peripherals and enables clocks for required modules
    //Configures GPIO and XBar as needed for EnDat operation
    //Sets up the SPI peripheral in endat data structure and enables interrupt
        EnDat_Init();

    //A template for running all the EnDat21 commands
    //This is optional in real applications.
    //Function defined in endat_commands.c
        endat21_runCommandSet();

        if (ENCODER_TYPE == 22)
        {
    //A template for running all the EnDat22 commands
    //This is optional in real applications.
    //Function defined in endat_commands.c

            endat22_runCommandSet();
        }

    //Enables 2 additional datas in endat22 operation
    //This is also optional in real applications. Function defined in endat.c

        endat22_setupAddlData();

    //Peforms cable propagation delay calculation.
    //This is required for long cable lengths and higher EnDat Clock frequencies
    //Function defined in endat.c

        EnDat_initDelayComp();

    //Switch to high frequency - 8.3MHz (=200/4*ENDAT_RUNTIME_FREQ_DIVIDER)
        PM_endat22_setFreq(ENDAT_RUNTIME_FREQ_DIVIDER);
        DELAY_US(800L);     //Delay 800us

        while(1)
        {
            if (ENCODER_TYPE == 22)
            {
    //Read position data in EnDat22 mode with 2 additional data enabled
    //earlier by endat22_setupAddlData function call.
    //Function defined in endat.c
                endat22_readPositionWithAddlData();
            }
            else
            {
    //Read position data in EnDat21 mode. Function defined in endat.c
                endat21_readPosition();
            }
        }
}




//
// End of File
//
