/*
 * initTMS.c
 *
 *  Created on: 23-Nov-2021
 *      Author: vishn
 */

#include "initTMS.h"
#include "operTMS.h"


extern __interrupt void timer1ISR(void);
extern void InitPieCtrl(void);
extern InitPieVectTable(void);

void initInterrupts(void)
{
    DINT;
    IER = 0x0000;
    IFR = 0x0000;
    InitPieCtrl();
    InitPieVectTable();
    PieCtrlRegs.PIECTRL.bit.ENPIE = 1;
    PieCtrlRegs.PIEACK.all = 0xFFFF;

    //TIMER1 interrupt
    EALLOW;
    PieVectTable.TIMER1_INT = &timer1ISR;
    EDIS;
    IER |= M_INT13;
    CpuTimer1Regs.TCR.bit.TIE = 1;

    EINT;
}

void initTimer1(uint32_t period)
{
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.CPUTIMER1=1;
    EDIS;
    CpuTimer1Regs.TCR.bit.TSS=1;
    CpuTimer1Regs.PRD.all=period;
    CpuTimer1Regs.TPR.bit.TDDR=9;
    CpuTimer1Regs.TPRH.bit.TDDRH=0;
    CpuTimer1Regs.TCR.bit.TRB=1;
    CpuTimer1Regs.TCR.bit.TSS=0;
}

