//#############################################################################
//
// FILE:   empty_driverlib_main.c
//
// TITLE:  Empty Project
//
// Empty Project Example
//
// This example is an empty project setup for Driverlib development.
//
//#############################################################################
//
//
// $Copyright:
// Copyright (C) 2021 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//#############################################################################

//
// Included Files
//

#include "gpio.h"
#include "sysctl.h"
#include "f28002x_sysctrl.h"
#include "f28002x_examples.h"
#include "f28002x_piectrl.h"
#include "initTMS.h"
#include "operTMS.h"

int loopcount;
int sysclk, lspclk;
uint64_t adcval_raw;
float adcval;
uint16_t writeData = 0x0000;
uint16_t readData;
uint16_t period = 250;
uint64_t loopTime,t1;

extern float time0;


void main(void){
    Device_init();
    initTimer1(0xFFFFFFFF);
//    initTimer1(1);

    EALLOW;
    GpioCtrlRegs.GPAGMUX1.bit.GPIO6 = 0x00;
    GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 0x00;
    GpioCtrlRegs.GPADIR.bit.GPIO6=1;
    EDIS;
    GpioDataRegs.GPACLEAR.bit.GPIO6=1;
    initInterrupts();

    while(1)
    {
        t1=micros();
        delay_us(20);
        GpioDataRegs.GPATOGGLE.bit.GPIO6=1;
        loopTime=micros()-t1;
    }
}
//
// End of File
//
