#ifndef _APP_SYSTEM_INIT_H_
#define _APP_SYSTEM_INIT_H_

#include "APP_SleepManage.h"

#define SYSTEM_VERSION_CODE 1;

#define MOTORSUM 1
#if MOTORSUM == 2
    #define MOTORNUM 2
#else
    #define MOTORNUM 1
#endif

//#define CPU_RATE 10.000L
#define DELAY_US(A)  DSP28x_usDelay(((((long double) A * 1000.0L) / (long double)CPU_RATE) - 9.0L) / 5.0L)


typedef enum
{
    Sleep,
    Run,
    ShutDown,
}eRunStatus;

typedef struct
{
    long (*GetSysTime)(void);
    long  ulSysTime;
}tSysTime;

typedef struct
{
    tSysTime        SysTime;

    tSleep          Sleep;

    tSysFonc        SysFonc;

    tScia           Scia;
}tSysCtrl;

extern tSysCtrl SysInfo;


void System_Init(void);

extern UINT64 GetSysTime();
extern void Delay_ms(UINT64 (*ReturnTime)(void),UINT32 ucSysTime);
extern void SystemRunTime(tSysTime *Systime);
#endif
