/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef BOARD_H
#define BOARD_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// ANALOG -> AdcPinMux Pinmux
//

//
// EPWM1 -> pwm_a Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define pwm_a_EPWMA_GPIO 0
#define pwm_a_EPWMA_PIN_CONFIG GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define pwm_a_EPWMB_GPIO 1
#define pwm_a_EPWMB_PIN_CONFIG GPIO_1_EPWM1_B

//
// EPWM2 -> pwm_b Pinmux
//
//
// EPWM2_A - GPIO Settings
//
#define GPIO_PIN_EPWM2_A 2
#define pwm_b_EPWMA_GPIO 2
#define pwm_b_EPWMA_PIN_CONFIG GPIO_2_EPWM2_A
//
// EPWM2_B - GPIO Settings
//
#define GPIO_PIN_EPWM2_B 3
#define pwm_b_EPWMB_GPIO 3
#define pwm_b_EPWMB_PIN_CONFIG GPIO_3_EPWM2_B

//
// EPWM12 -> pwm_c Pinmux
//
//
// EPWM12_A - GPIO Settings
//
#define GPIO_PIN_EPWM12_A 23
#define pwm_c_EPWMA_GPIO 23
#define pwm_c_EPWMA_PIN_CONFIG GPIO_23_EPWM12_A
//
// EPWM12_B - GPIO Settings
//
#define GPIO_PIN_EPWM12_B 41
#define pwm_c_EPWMB_GPIO 41
#define pwm_c_EPWMB_PIN_CONFIG GPIO_41_EPWM12_B

//
// EPWM8 -> pwm_break Pinmux
//
//
// EPWM8_A - GPIO Settings
//
#define GPIO_PIN_EPWM8_A 24
#define pwm_break_EPWMA_GPIO 24
#define pwm_break_EPWMA_PIN_CONFIG GPIO_24_EPWM8_A
//
// EPWM8_B - GPIO Settings
//
#define GPIO_PIN_EPWM8_B 32
#define pwm_break_EPWMB_GPIO 32
#define pwm_break_EPWMB_PIN_CONFIG GPIO_32_EPWM8_B
//
// GPIO33 - GPIO Settings
//
#define rs485_ena_GPIO_PIN_CONFIG GPIO_33_GPIO33
//
// GPIO15 - GPIO Settings
//
#define fan_ctrl_GPIO_PIN_CONFIG GPIO_15_GPIO15
//
// GPIO42 - GPIO Settings
//
#define relay_ctrl_GPIO_PIN_CONFIG GPIO_42_GPIO42
//
// GPIO46 - GPIO Settings
//
#define v2_ctrl_GPIO_PIN_CONFIG GPIO_46_GPIO46
//
// GPIO30 - GPIO Settings
//
#define di1_GPIO_PIN_CONFIG GPIO_30_GPIO30
//
// GPIO62 - GPIO Settings
//
#define di2_GPIO_PIN_CONFIG GPIO_62_GPIO62
//
// GPIO43 - GPIO Settings
//
#define di3_GPIO_PIN_CONFIG GPIO_43_GPIO43
//
// GPIO25 - GPIO Settings
//
#define bus_ov_GPIO_PIN_CONFIG GPIO_25_GPIO25
//
// GPIO9 - GPIO Settings
//
#define bus_uv_GPIO_PIN_CONFIG GPIO_9_GPIO9

//
// I2CA -> i2c_a Pinmux
//
//
// I2CA_SDA - GPIO Settings
//
#define GPIO_PIN_I2CA_SDA 26
#define i2c_a_I2CSDA_GPIO 26
#define i2c_a_I2CSDA_PIN_CONFIG GPIO_26_I2CA_SDA
//
// I2CA_SCL - GPIO Settings
//
#define GPIO_PIN_I2CA_SCL 27
#define i2c_a_I2CSCL_GPIO 27
#define i2c_a_I2CSCL_PIN_CONFIG GPIO_27_I2CA_SCL

//
// SCIA -> sci_a Pinmux
//
//
// SCIA_RX - GPIO Settings
//
#define GPIO_PIN_SCIA_RX 17
#define sci_a_SCIRX_GPIO 17
#define sci_a_SCIRX_PIN_CONFIG GPIO_17_SCIA_RX
//
// SCIA_TX - GPIO Settings
//
#define GPIO_PIN_SCIA_TX 16
#define sci_a_SCITX_GPIO 16
#define sci_a_SCITX_PIN_CONFIG GPIO_16_SCIA_TX

//
// SCIB -> sci_b Pinmux
//
//
// SCIB_RX - GPIO Settings
//
#define GPIO_PIN_SCIB_RX 13
#define sci_b_SCIRX_GPIO 13
#define sci_b_SCIRX_PIN_CONFIG GPIO_13_SCIB_RX
//
// SCIB_TX - GPIO Settings
//
#define GPIO_PIN_SCIB_TX 12
#define sci_b_SCITX_GPIO 12
#define sci_b_SCITX_PIN_CONFIG GPIO_12_SCIB_TX

//*****************************************************************************
//
// ADC Configurations
//
//*****************************************************************************
#define adc_a_BASE ADCA_BASE
#define adc_a_RESULT_BASE ADCARESULT_BASE
#define adc_a_SOC0 ADC_SOC_NUMBER0
#define adc_a_FORCE_SOC0 ADC_FORCE_SOC0
#define adc_a_SAMPLE_WINDOW_SOC0 80
#define adc_a_TRIGGER_SOURCE_SOC0 ADC_TRIGGER_SW_ONLY
#define adc_a_CHANNEL_SOC0 ADC_CH_ADCIN0
#define adc_a_SOC1 ADC_SOC_NUMBER1
#define adc_a_FORCE_SOC1 ADC_FORCE_SOC1
#define adc_a_SAMPLE_WINDOW_SOC1 80
#define adc_a_TRIGGER_SOURCE_SOC1 ADC_TRIGGER_SW_ONLY
#define adc_a_CHANNEL_SOC1 ADC_CH_ADCIN0
#define adc_a_SOC2 ADC_SOC_NUMBER2
#define adc_a_FORCE_SOC2 ADC_FORCE_SOC2
#define adc_a_SAMPLE_WINDOW_SOC2 80
#define adc_a_TRIGGER_SOURCE_SOC2 ADC_TRIGGER_SW_ONLY
#define adc_a_CHANNEL_SOC2 ADC_CH_ADCIN0
void adc_a_init();

#define adc_b_BASE ADCB_BASE
#define adc_b_RESULT_BASE ADCBRESULT_BASE
#define adc_b_SOC0 ADC_SOC_NUMBER0
#define adc_b_FORCE_SOC0 ADC_FORCE_SOC0
#define adc_b_SAMPLE_WINDOW_SOC0 80
#define adc_b_TRIGGER_SOURCE_SOC0 ADC_TRIGGER_SW_ONLY
#define adc_b_CHANNEL_SOC0 ADC_CH_ADCIN0
#define adc_b_SOC1 ADC_SOC_NUMBER1
#define adc_b_FORCE_SOC1 ADC_FORCE_SOC1
#define adc_b_SAMPLE_WINDOW_SOC1 80
#define adc_b_TRIGGER_SOURCE_SOC1 ADC_TRIGGER_SW_ONLY
#define adc_b_CHANNEL_SOC1 ADC_CH_ADCIN0
#define adc_b_SOC2 ADC_SOC_NUMBER2
#define adc_b_FORCE_SOC2 ADC_FORCE_SOC2
#define adc_b_SAMPLE_WINDOW_SOC2 80
#define adc_b_TRIGGER_SOURCE_SOC2 ADC_TRIGGER_SW_ONLY
#define adc_b_CHANNEL_SOC2 ADC_CH_ADCIN0
void adc_b_init();

#define adc_c_BASE ADCC_BASE
#define adc_c_RESULT_BASE ADCCRESULT_BASE
#define adc_c_SOC0 ADC_SOC_NUMBER0
#define adc_c_FORCE_SOC0 ADC_FORCE_SOC0
#define adc_c_SAMPLE_WINDOW_SOC0 80
#define adc_c_TRIGGER_SOURCE_SOC0 ADC_TRIGGER_SW_ONLY
#define adc_c_CHANNEL_SOC0 ADC_CH_ADCIN0
#define adc_c_SOC1 ADC_SOC_NUMBER1
#define adc_c_FORCE_SOC1 ADC_FORCE_SOC1
#define adc_c_SAMPLE_WINDOW_SOC1 80
#define adc_c_TRIGGER_SOURCE_SOC1 ADC_TRIGGER_SW_ONLY
#define adc_c_CHANNEL_SOC1 ADC_CH_ADCIN0
void adc_c_init();


//*****************************************************************************
//
// ASYSCTL Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// CMPSS Configurations
//
//*****************************************************************************
#define cmp1_BASE CMPSS1_BASE
#define cmp1_HIGH_COMP_BASE CMPSS1_BASE    
#define cmp1_LOW_COMP_BASE CMPSS1_BASE    
void cmp1_init();

//*****************************************************************************
//
// CPUTIMER Configurations
//
//*****************************************************************************
#define cpu_timer1_BASE CPUTIMER1_BASE
void cpu_timer1_init();

//*****************************************************************************
//
// ECAP Configurations
//
//*****************************************************************************
#define cap1_BASE ECAP1_BASE
#define cap1_SIGNAL_MUNIT_BASE ECAP1SIGNALMONITORING_BASE
void cap1_init();

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define pwm_a_BASE EPWM1_BASE
#define pwm_a_TBPRD 2000
#define pwm_a_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define pwm_a_TBPHS 0
#define pwm_a_CMPA 50
#define pwm_a_CMPB 1950
#define pwm_a_CMPC 0
#define pwm_a_CMPD 0
#define pwm_a_DBRED 150
#define pwm_a_DBFED 150
#define pwm_a_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define pwm_a_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define pwm_a_OSHT_SOURCES EPWM_TZ_SIGNAL_OSHT1
#define pwm_a_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED
#define pwm_b_BASE EPWM2_BASE
#define pwm_b_TBPRD 2000
#define pwm_b_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define pwm_b_TBPHS 0
#define pwm_b_CMPA 50
#define pwm_b_CMPB 1950
#define pwm_b_CMPC 0
#define pwm_b_CMPD 0
#define pwm_b_DBRED 150
#define pwm_b_DBFED 150
#define pwm_b_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define pwm_b_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define pwm_b_OSHT_SOURCES EPWM_TZ_SIGNAL_OSHT1
#define pwm_b_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED
#define pwm_c_BASE EPWM12_BASE
#define pwm_c_TBPRD 2000
#define pwm_c_COUNTER_MODE EPWM_COUNTER_MODE_STOP_FREEZE
#define pwm_c_TBPHS 0
#define pwm_c_CMPA 50
#define pwm_c_CMPB 1950
#define pwm_c_CMPC 0
#define pwm_c_CMPD 0
#define pwm_c_DBRED 150
#define pwm_c_DBFED 150
#define pwm_c_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define pwm_c_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define pwm_c_OSHT_SOURCES EPWM_TZ_SIGNAL_OSHT1
#define pwm_c_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED
#define pwm_break_BASE EPWM8_BASE
#define pwm_break_TBPRD 20000
#define pwm_break_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define pwm_break_TBPHS 0
#define pwm_break_CMPA 0
#define pwm_break_CMPB 0
#define pwm_break_CMPC 0
#define pwm_break_CMPD 0
#define pwm_break_DBRED 0
#define pwm_break_DBFED 0
#define pwm_break_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define pwm_break_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define pwm_break_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
#define rs485_ena 33
void rs485_ena_init();
#define fan_ctrl 15
void fan_ctrl_init();
#define relay_ctrl 42
void relay_ctrl_init();
#define v2_ctrl 46
void v2_ctrl_init();
#define di1 30
void di1_init();
#define di2 62
void di2_init();
#define di3 43
void di3_init();
#define bus_ov 25
void bus_ov_init();
#define bus_uv 9
void bus_uv_init();

//*****************************************************************************
//
// I2C Configurations
//
//*****************************************************************************
#define i2c_a_BASE I2CA_BASE
#define i2c_a_BITRATE 400000
#define i2c_a_TARGET_ADDRESS 0
#define i2c_a_OWN_ADDRESS 0
#define i2c_a_MODULE_CLOCK_FREQUENCY 10000000
void i2c_a_init();

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

// Interrupt Settings for INT_cpu_timer1
// ISR need to be defined for the registered interrupts
#define INT_cpu_timer1 INT_TIMER1
extern __interrupt void INT_cpu_timer1_ISR(void);

//*****************************************************************************
//
// SCI Configurations
//
//*****************************************************************************
#define sci_a_BASE SCIA_BASE
#define sci_a_BAUDRATE 115200
#define sci_a_CONFIG_WLEN SCI_CONFIG_WLEN_8
#define sci_a_CONFIG_STOP SCI_CONFIG_STOP_ONE
#define sci_a_CONFIG_PAR SCI_CONFIG_PAR_NONE
#define sci_a_FIFO_TX_LVL SCI_FIFO_TX0
#define sci_a_FIFO_RX_LVL SCI_FIFO_RX0
void sci_a_init();
#define sci_b_BASE SCIB_BASE
#define sci_b_BAUDRATE 115200
#define sci_b_CONFIG_WLEN SCI_CONFIG_WLEN_8
#define sci_b_CONFIG_STOP SCI_CONFIG_STOP_ONE
#define sci_b_CONFIG_PAR SCI_CONFIG_PAR_NONE
#define sci_b_FIFO_TX_LVL SCI_FIFO_TX0
#define sci_b_FIFO_RX_LVL SCI_FIFO_RX0
void sci_b_init();

//*****************************************************************************
//
// SYNC Scheme Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	ADC_init();
void	ASYSCTL_init();
void	CMPSS_init();
void	CPUTIMER_init();
void	ECAP_init();
void	EPWM_init();
void	GPIO_init();
void	I2C_init();
void	INTERRUPT_init();
void	SCI_init();
void	SYNC_init();
void	PinMux_init();

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif  // end of BOARD_H definition
