#ifndef HARDWARE_DEF_H_
#define HARDWARE_DEF_H_

//RAM Function Linker Section
#ifdef __TI_COMPILER_VERSION__
    #if __TI_COMPILER_VERSION__ >= 15009000
        #define ramFuncSection ".TI.ramfunc"
    #else
        #define ramFuncSection "ramfuncs"
    #endif
#endif

/******************************************************************************
 * GPIO for the operation LED
 *****************************************************************************/
#define ON					~0
#define OFF					0
#define LED_OP_BASE         GPIO_PORTP_BASE
#define LED_OP_PIN          GPIO_PIN_5

/******************************************************************************
 * GPIO for the debug pin CON9 GPIO0
 *****************************************************************************/
#define DEBUG_BASE         GPIO_PORTG_BASE
#define DEBUG_PIN          GPIO_PIN_6

/******************************************************************************
 * Macros for onboard I2C
 *****************************************************************************/
#define	I2C_ONBOARD_MASTER_BASE		I2C0_MASTER_BASE
#define I2C_ONBOARD_BASE	  		GPIO_PORTN_BASE
#define I2C_ONBOARD_PINS 			(GPIO_PIN_0 | GPIO_PIN_1)
#define I2C_ONBOARD_SCL				GPIO_PN0_I2C0SCL
#define I2C_ONBOARD_SDA 			GPIO_PN1_I2C0SDA
#define I2C_ONBOARD_SYSCTL			SYSCTL_PERIPH_I2C0

/******************************************************************************
 * Macros for WP EEPROM
 *****************************************************************************/
#define EEPROM_WP_BASE		GPIO_PORTP_BASE
#define EEPROM_WP_PIN		GPIO_PIN_4

/******************************************************************************
 * Macros for offboard I2C isolated
 *****************************************************************************/
#define	I2C_OFFBOARD_ISO_MASTER_BASE	I2C1_MASTER_BASE
#define I2C_OFFBOARD_ISO_SLAVE_BASE     I2C1_SLAVE_BASE
#define I2C_OFFBOARD_ISO_BASE			GPIO_PORTP_BASE
#define I2C_OFFBOARD_ISO_PINS 			(GPIO_PIN_0 | GPIO_PIN_1)
#define I2C_OFFBOARD_ISO_SCL			GPIO_PP0_I2C1SCL
#define I2C_OFFBOARD_ISO_SDA 			GPIO_PP1_I2C1SDA
#define I2C_OFFBOARD_ISO_SYSCTL			SYSCTL_PERIPH_I2C1

/******************************************************************************
 * Macros for RS-485 communication
 *****************************************************************************/
#define RS485_BASE			GPIO_PORTN_BASE
#define	RS485_PINS			(GPIO_PIN_2 | GPIO_PIN_3)
#define RS485_RX			GPIO_PN2_U1RX
#define	RS485_TX			GPIO_PN3_U1TX
#define RS485_SYSCTL       	SYSCTL_PERIPH_UART1

#define RS485_RD_BASE		GPIO_PORTP_BASE
#define RS485_RD_PIN		GPIO_PIN_2

#define RS485_UART_BASE		UART1_BASE
#define RS485_INT			INT_UART1

#endif /* HARDWARE_DEF_H_ */
