/**
 * TODO: Put here your includes
 */
#include <stdint.h>
#include <stdbool.h>

#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "inc/hw_nvic.h"
#include "inc/hw_types.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_ipc.h"
#include "inc/hw_flash.h"
#include "driverlib/debug.h"
#include "driverlib/ipc.h"
#include "driverlib/interrupt.h"
#include "driverlib/sysctl.h"
#include "driverlib/flash.h"
#include "driverlib/device.h"
#include "driverlib/dcsm.h"

/******************************************************************************
 * FILE Flash API include file
 *****************************************************************************/
#include "F021_Concerto_Cortex.h"

#include "hardware_def.h"
#include "flash.h"

/******************************************************************************
 *                          Lengths of sectors
 *****************************************************************************/
#define Bzero_16KSector_u32length   0x1000
#define Bzero_32KSector_u32length   0x2000
#define Bzero_64KSector_u32length   0x4000
#define Bzero_128KSector_u32length  0x8000

/******************************************************************************
 * Flags that contain the current value of the interrupt indicator as displayed
 * on the CSTN display.
 *****************************************************************************/
unsigned long g_ulFlags;

//#pragma DATA_SECTION(Buffer, "SERIALBUFFER")
//uint8_t   Buffer[BYTES_IN_FLASH_BUFFER + 1];


Fapi_StatusType                     oReturnCheck;
volatile Fapi_LibraryInfoType       oLibInfo;
volatile Fapi_FlashStatusType       oFlashStatus;
Fapi_FlashBankSectorsType           oFlashBankSectors;
Fapi_FlashStatusWordType            oFlashStatusWord;

/**
 * TODO: Put here your function prototypes for private functions. Use
 * static in declaration.
 */
static void erase_arm_flash(void);
static void load_arm_firmware(void);
static void load_c28_firmware(void);
static void write_test_data();
static void teste();

//******************************************************************************
// For this example, just stop here if FMSTAT fail occurs
//******************************************************************************
#pragma CODE_SECTION(FMSTAT_Fail, ramFuncSection);
void FMSTAT_Fail(void)
{
    //  Error code will be in the status parameter
    for(;;);
}

//*****************************************************************************
// For this example, if an error is found just stop here
//*****************************************************************************
#pragma CODE_SECTION(Example_Error,ramFuncSection);
void Example_Error(Fapi_StatusType status)
{
    //  Error code will be in the status parameter
        for(;;);
}

/**
 * TODO: Put here the implementation for your public functions.
 */
#pragma CODE_SECTION(initialize_flash_api, ramFuncSection);
extern uint8_t initialize_flash_api(void)
{
    //FlashGainPump();

    oReturnCheck = Fapi_initializeAPI(F021_CPU0_BASE_ADDRESS, 75);

    //FlashLeavePump();

    return oReturnCheck;
}

#pragma CODE_SECTION(flash_arm_firmware, ramFuncSection);
void flash_arm_firmware(struct firmware_img *img)
{
    volatile uint16_t i = 0;
    volatile uint32_t u32Index = 0;

    //FlashGainPump();

    erase_arm_flash();

    // Example: Program received bytes in Flash Sector M along with auto generated ECC

    // A data buffer of max 16 bytes can be supplied to the program function.
    // Each word is programmed until the whole buffer is programmed or a
    // problem is found.
    // However to program more a buffer that has more than 16 bytes,
    // program function can be called in a loop to program 16 bytes for each
    // loop iteration until the whole buffer is programmed

    // When AutoEccGeneration option is used, Flash API calculates ECC for the given
    // 64-bit data and programs it along with the 64-bit main array data.
    // Note that any unprovided data with in a 64-bit data slice
    // will be assumed as 1s for calculating ECC and will be programmed.

    for(i=0, u32Index = Bzero_SectorL_start;
       (u32Index < (Bzero_SectorL_start + img->len.u32))
        && (oReturnCheck == Fapi_Status_Success); i+= 16, u32Index+= 16)
    {
        oReturnCheck = Fapi_issueProgrammingCommand((uint32 *)u32Index,
                       img->data+i,
                       16,
                       0,
                       0,
                       Fapi_AutoEccGeneration);

        while(Fapi_checkFsmForReady() == Fapi_Status_FsmBusy);

        if(oReturnCheck != Fapi_Status_Success)
        {
            // Check Flash API documentation for possible errors
            Example_Error(oReturnCheck);
        }

        // Read FMSTAT register contents to know the status of FSM after
        // program command to see if there are any program operation related errors
        oFlashStatus = Fapi_getFsmStatus();
        if(oFlashStatus != 0)
        {
            //Check FMSTAT and debug accordingly
            FMSTAT_Fail();
        }

        // Verify the values programmed.  The Program step itself does a verify
        // as it goes.  This verify is a 2nd verification that can be done.
        oReturnCheck = Fapi_doVerifyByByte((uint8 *)u32Index,
                       16,
                       img->data+i,
                       &oFlashStatusWord);

        if(oReturnCheck != Fapi_Status_Success)
        {
            // Check Flash API documentation for possible errors
            Example_Error(oReturnCheck);
        }
    }

    FlashLeavePump();
}

void flash_c28_firmware(void)
{

}

/**
 * TODO: Put here the implementation for your private functions.
 */
#pragma CODE_SECTION(erase_arm_flash, ramFuncSection);
static void erase_arm_flash(void)
{
    /**************************************************************************
     * Erase Sector L
     *************************************************************************/
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorL_start);

    // Wait until FSM is done with erase sector operation
    while (Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    // Verify that Sector L is erased.  The Erase step itself does a verify
    // as it goes.  This verify is a 2nd verification that can be done.
    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorL_start,
                 Bzero_16KSector_u32length,
                   &oFlashStatusWord);
    if(oReturnCheck != Fapi_Status_Success)
    {
        //Check Flash API documentation for possible errors
        //If Erase command fails, use Fapi_getFsmStatus() function to get
        // the FMSTAT register contents
        //to see if any of the EV bit, ESUSP bit, CSTAT bit or VOLTSTAT
        //bit is set (Refer to API documentation for more details)
        Example_Error(oReturnCheck);
    }


}

static void jump_stc_pointer(uint32_t add)
{
    __asm(" mov sp, r0\n"   // sp is now *add
          " bx r0\n" );     // jump to *add
}

//typedef void (*app_start_t)(void);

void jump_to_app() {

    //IntMasterDisable();

    /* Disable Peripherals*/
    SysCtlPeripheralDisable(SYSCTL_PERIPH_GPION);    // RS485 pins
    SysCtlPeripheralDisable(SYSCTL_PERIPH_GPIOP);    // RD pins
    SysCtlPeripheralDisable(RS485_SYSCTL);

    //UARTDisable(RS485_UART_BASE);

    HWREG(NVIC_DIS0) = 0xffffffff;
    HWREG(NVIC_DIS1) = 0xffffffff;
    HWREG(NVIC_DIS2) = 0xffffffff;
    HWREG(NVIC_DIS3) = 0xffffffff;
    HWREG(NVIC_DIS4) = 0xffffffff;

    //app_start_t mainfunc = 0x00210000; // Flash_L address
    //(*mainfunc)();

    jump_stc_pointer(0x00210000);

    //((void(*)(void))(*((unsigned int *)0x00210000)))();


}

