#ifndef FLASH_H_
#define FLASH_H_

#include <stdint.h>

/**
 * TODO: Put here your defines. Just what need 
 * to be accessed by other modules.
 */
#define Bzero_SectorN_start        0x00200000
#define Bzero_SectorN_End          0x00207FFF

#define Bzero_SectorM_start        0x00208000
#define Bzero_SectorM_End          0x0020FFFF

#define Bzero_SectorL_start        0x00210000
#define Bzero_SectorL_End          0x00217FFF

#define Bzero_SectorK_start        0x00218000
#define Bzero_SectorK_End          0x0021FFFF

#define Bzero_SectorJ_start        0x00220000
#define Bzero_SectorJ_End          0x0023FFFF

#define Bzero_SectorI_start        0x00240000
#define Bzero_SectorI_End          0x0025FFFF

#define Bzero_SectorH_start        0x00260000
#define Bzero_SectorH_End          0x0027FFFF

#define Bzero_SectorG_start        0x00280000
#define Bzero_SectorG_End          0x0029FFFF

#define Bzero_SectorF_start        0x002A0000
#define Bzero_SectorF_End          0x002BFFFF

#define Bzero_SectorE_start        0x002C0000
#define Bzero_SectorE_End          0x002DFFFF

#define Bzero_SectorD_start        0x002E0000
#define Bzero_SectorD_End          0x002E7FFF

#define Bzero_SectorC_start        0x002E8000
#define Bzero_SectorC_End          0x002EFFFF

#define Bzero_SectorB_start        0x002F0000
#define Bzero_SectorB_End          0x002F7FFF

#define Bzero_SectorA_start        0x002F8000
#define Bzero_SectorA_End          0x002FFFFF

struct firmware_img
{
    uint8_t *data;
    union {
        uint32_t u32;
        uint8_t u8[4];
    } len;
};



/**
 * TODO: Put here your functions prototypes. Just what need 
 * to be accessed by other modules.
 */
extern uint8_t initialize_flash_api(void);
void flash_arm_firmware(struct firmware_img *img);
//extern void flash_arm_firmware();
//extern void flash_c28_firmware(struct firmware_img *img);
extern void flash_c28_firmware();

extern void jump_to_app();

#endif /* APP_FLASH_FLASH_H_ */
