#include <stdint.h>
#include <stdbool.h>

#include "uart.h"
#include "system_task.h"

static volatile uint8_t NEW_SERIAL_DATA = 0;

void set_new_task(uint8_t task_num)
{
	switch(task_num)
	{
	case PROCESS_SERIAL_MESSAGE:
		NEW_SERIAL_DATA = 1;
		break;

	default:
		break;
	}
}

void task_check(void)
{
	if(NEW_SERIAL_DATA)
	{
	    NEW_SERIAL_DATA = 0;
	    process_serial_data();
	}
}
