/**
 * TODO: Put here your includes
 */
#include <stdint.h>
#include <stdbool.h>

#include "inc/hw_gpio.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_udma.h"
#include "inc/hw_ints.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "driverlib/interrupt.h"
#include "driverlib/debug.h"
#include "driverlib/gpio.h"
#include "driverlib/rom.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "driverlib/ucrc.h"

#include "hardware_def.h"
#include "system_task.h"
#include "flash.h"
#include "uart.h"

/**
 * TODO: Put here your defines. Just what is local. If you don't
 * need to access it from other module, consider use a constant (const)
 */
#define SERIAL_MASTER_ADDRESS       0
#define SERIAL_SLAVE_ADDRESS        55
#define SERIAL_BCAST_ADDRESS        255

#define SERIAL_BUFFER_SIZE          16384
#define SERIAL_BAUDRATE             115200

#define ID_ARM_CORE                 0
#define ID_C28_CORE                 1

/**
 * TODO: Put here your constants and variables. Always use static for 
 * private members.
 */
struct serial_buffer
{
    uint8_t data[SERIAL_BUFFER_SIZE];
    uint32_t index;
};

#pragma DATA_SECTION(receive_buffer, "SERIALBUFFER")
static struct serial_buffer receive_buffer = {.index = 0};

static struct firmware_img image = {.data = &receive_buffer.data[7]};

volatile uint8_t teste;
volatile uint8_t crc_ok = 0;

/**
 * TODO: Put here your function prototypes for private functions. Use
 * static in declaration.
 */
static void isr_uart_handler(void);

/**
 * TODO: Put here the implementation for your public functions.
 */
void initialize_uart(void)
{

    /* Configure RS485 */
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPION);    // RS485 pins
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOP);    // RD pins
    SysCtlPeripheralEnable(RS485_SYSCTL);
    GPIOPinTypeUART(RS485_BASE, RS485_PINS);
    GPIOPinConfigure(RS485_RX);
    GPIOPinConfigure(RS485_TX);

    /* Configure Transceiver RD */
    GPIOPinTypeGPIOOutput(RS485_RD_BASE, RS485_RD_PIN);
    GPIOPinWrite(RS485_RD_BASE, RS485_RD_PIN, OFF);

    /* Enable RS485 */
    UARTConfigSetExpClk(RS485_UART_BASE, SysCtlClockGet(SYSTEM_CLOCK_SPEED),
                        SERIAL_BAUDRATE, (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE |
                        UART_CONFIG_PAR_NONE));
    IntRegister(RS485_INT, isr_uart_handler);
    UARTIntEnable(RS485_UART_BASE, UART_INT_RX | UART_INT_RT);
    UARTEnable(RS485_UART_BASE);
    IntEnable(RS485_INT);

}

uint8_t crc_data = 0;
uint8_t crc_calc = 0;
uint16_t crc_index = 0;
void process_serial_data(void)
{
    uint8_t crc = 0;
    uint32_t crc_position = 0;

    //UARTIntDisable(RS485_UART_BASE, UART_INT_RX | UART_INT_RT);
    //IntDisable(RS485_UART_BASE);

    //receive_buffer.index = 0;

    if ((receive_buffer.data[1] == SERIAL_SLAVE_ADDRESS) ||
        (receive_buffer.data[1] == SERIAL_BCAST_ADDRESS))
    {
        //image.len.u8[0] = receive_buffer.data[3];
        //image.len.u8[1] = receive_buffer.data[4];
        //image.len.u8[2] = receive_buffer.data[5];
        //image.len.u8[3] = receive_buffer.data[6];

        crc = UCRCCalculation(UCRC_BASE, UCRC_CONFIG_CRC8,
                              &receive_buffer.data[7], image.len.u32);

        crc_position = image.len.u32 + 7;
        crc_index = crc_position;

        if (crc == receive_buffer.data[crc_position]) {

            crc_ok = 1;

            if (receive_buffer.data[2] == ID_ARM_CORE) {
                flash_arm_firmware(&image);
            }

            if (receive_buffer.data[2] == ID_C28_CORE) {
                flash_c28_firmware(&image);
            }
        }
    } else {
        receive_buffer.index = 0;
    }

    //UARTIntEnable(RS485_UART_BASE, UART_INT_RX | UART_INT_RT);
    //IntEnable(RS485_UART_BASE);

    jump_to_app();
}

/**
 * TODO: Put here the implementation for your private functions.
 */
#pragma CODE_SECTION(isr_uart_handler, ramFuncSection);
static void isr_uart_handler(void)
{
    uint32_t ulStatus;
    uint8_t timeout = 0;

    //receive_buffer.index = 0;

    // Get the interrrupt status.
    ulStatus = UARTIntStatus(RS485_UART_BASE, true);

    // Clear the asserted interrupts.
    UARTIntClear(RS485_UART_BASE, ulStatus);

    if(UARTRxErrorGet(RS485_UART_BASE)) UARTRxErrorClear(RS485_UART_BASE);

    // Receive Interrupt Mask
    if(UART_INT_RX == ulStatus || UART_INT_RT == ulStatus)
    {
        for (timeout = 0; timeout < 15; timeout++)
        {
            // Loop while there are characters in the receive FIFO.
            while(UARTCharsAvail(RS485_UART_BASE) &&
                    receive_buffer.index < SERIAL_BUFFER_SIZE)
            {
                receive_buffer.data[receive_buffer.index++] =
                        (uint8_t) UARTCharGet(RS485_UART_BASE);
                //receive_buffer.index++;
                timeout = 0;
            }
        }

        image.len.u8[0] = receive_buffer.data[3];
        image.len.u8[1] = receive_buffer.data[4];
        image.len.u8[2] = receive_buffer.data[5];
        image.len.u8[3] = receive_buffer.data[6];

        if (receive_buffer.index >= image.len.u32 + 7)
        {
            set_new_task(PROCESS_SERIAL_MESSAGE);
        }
    }


}
