/**********************************************************************
* File: f28335_BIOS_flash.cmd -- Linker command file for DSP/BIOS code
* with DSP in Boot to Flash bootmode.
*
* History: 09/29/08 - Corrected linkage of internalMemFuncs (D. Alter)
*          12/13/07 - original (D. Alter)
*          06/10/09 - Added ram sections for viterbi and fft
**********************************************************************/



MEMORY
{
 PAGE 0:    /* Program Memory */

 PAGE 1:    /* Data Memory */

}


/**************************************************************/
/* Link all user defined sections                             */
/**************************************************************/
SECTIONS
{
   /*** User Defined Sections ***/
   // R.Liang: PLC starts from 0x3DC000
   sys_entry		 : > 0x3DC000,        PAGE = 0           /* crc */
   g3_version		 : > 0x3DC010,        PAGE = 0  
   codestart         : > BEGIN_FLASH,     PAGE = 0           /* Used by file CodeStartBranch.asm */
   .adc_cal          : > FLASH,           PAGE = 0           /* Used by file CodeStartBranch.asm */
    /* Allocate ADC_cal function (pre-programmed by factory into TI reserved memory) */
   /* shadow memory for work buffers  */
   .shadow           : > L8SARAM,        PAGE = 1            /* must be different from the main data memory */
   ramfuncs          : > FLASH,           PAGE = 0           /* Used by file CodeStartBranch.asm */

   // Constant Tables in flash
   AES_TABLE         : > FLASH,           PAGE = 0           /* aes */
   PHY_TABLE         : > FLASH,           PAGE = 0           /* phy fft */
   PHY_TABLE_RX      : > FLASH,           PAGE = 0           /* phy rx */
  
   // Constant Tables in flash
   secureRamFuncs    :   LOAD = FLASH, PAGE = 0                   /* Can be Flash */ 
                         RUN  = L7SARAM,      PAGE = 1           /* Must be CSM secured RAM */
                         LOAD_START(_secureRamFuncs_loadstart),
                         LOAD_END(_secureRamFuncs_loadend),
                         RUN_START(_secureRamFuncs_runstart)

   // Critical PHY functions run from RAM
   phyRamFuncs       :   LOAD = FLASH, PAGE = 0           
                         RUN  = L7SARAM,      PAGE = 1           
                         LOAD_START(_phyRamFuncs_loadstart),
                         LOAD_END(_phyRamFuncs_loadend),
                         RUN_START(_phyRamFuncs_runstart)

   // Critical PHY filter coefficients
   phyFirCoefs       :   LOAD = FLASH, PAGE = 0           
                         RUN  = L36SARAM,      PAGE = 1           
                         LOAD_START(_phyFirCoefs_loadstart),
                         LOAD_END(_phyFirCoefs_loadend),
                         RUN_START(_phyFirCoefs_runstart)

   // RL: put the MAC data in L0SARAM memory
   // This memory is generated by BIOS
   mac_data_section_1	: > L0SARAM, PAGE = 1    
   appemu_data_section  : > L0SARAM, PAGE = 1   
   acm_data_section     : > L0SARAM, PAGE = 1  
   mac_data_section_2   : > L8SARAM, PAGE = 1              
}

/******************* end of file ************************/
