//###########################################################################
//
// FILE:   F2806x_Comp.h
//
// TITLE:  F2806x Device COMP Register Definitions.
//
//###########################################################################
// $TI Release:   $
// $Release Date:   $
//###########################################################################

#ifndef F2806x_COMP_H
#define F2806x_COMP_H

#ifdef __cplusplus
extern "C" {
#endif


//---------------------------------------------------------------------------
// COMP Individual Register Bit Definitions:

struct COMPCTL_BITS {     // bits description
	Uint16	COMPDACEN:1;			// 0	Comparator/DAC Enable
	Uint16	COMPSOURCE:1;			// 1	Source Select for inverting input
	Uint16	CMPINV:1;			// 2	Invert Select for Comparator
	Uint16	QUALSEL:5;			// 7:3	Qualification Period for synchronized output
	Uint16	SYNCSEL:1;			// 8	Synchronization select before ETPWM/GPIO
	Uint16	rsvd1:7;			// 15:9	Reserved
};

union COMPCTL_REG {
	Uint16 all;
	struct COMPCTL_BITS	bit;
};

struct COMPSTS_BITS {     // bits description
	Uint16	COMPSTS:1;			// 0	Logical latched value of the comparator
	Uint16	rsvd1:15;			// 15:1	Reserved
};

union COMPSTS_REG {
	Uint16 all;
	struct COMPSTS_BITS	bit;
};

struct DACCTL_BITS {     // bits description
	Uint16	DACSOURCE:1;			// 0	DAC source control bits
	Uint16	RAMPSOURCE:4;			// 4:1	Ramp generator source contol bits
	Uint16	rsvd1:9;			// 13:5	Reserved
	Uint16	FREE_SOFT:2;			// 15:14	Ramp generator
};

union DACCTL_REG {
	Uint16 all;
	struct DACCTL_BITS	bit;
};

struct DACVAL_BITS {     // bits description
	Uint16	DACVAL:10;			// 9:0	DAC Value bits
	Uint16	rsvd1:6;			// 15:10	Reserved
};

union DACVAL_REG {
	Uint16 all;
	struct DACVAL_BITS	bit;
};

struct TEST_BITS {     // bits description
	Uint16	TESTEN:1;			// 0	Analog test option
	Uint16	rsvd1:15;			// 15:1	Reserved
};

union TEST_REG {
	Uint16 all;
	struct TEST_BITS	bit;
};

struct COMP_REGS {
	union	COMPCTL_REG	COMPCTL;			// Comparator Control
	Uint16				rsvd1;				// Reserved
	union	COMPSTS_REG	COMPSTS;			// Compare Output States
	Uint16				rsvd2;				// Reserved
	union	DACCTL_REG	DACCTL;				// DAC Control
	Uint16				rsvd3;				// Reserved
	union	DACVAL_REG	DACVAL;				// 10-bit DAV Value
	Uint16				rsvd4;				// Reserved
	Uint16				RAMPMAXREF_ACTIVE;	// Ramp Gen. Max Value Active
	Uint16				rsvd5;				// Reserved
	Uint16				RAMPMAXREF_SHDW;	// Ramp Gen. Max Value Shadow
	Uint16				rsvd6;				// Reserved
	Uint16				RAMPDECVAL_ACTIVE;	// Ramp Gen Decrement Value Active
	Uint16				rsvd7;				// Reserved
	Uint16				RAMPDECVAL_SHDW;	// Ramp Gen. Decrement Value Shadow
	Uint16				rsvd8;				// Reserved
	Uint16				RAMPSTS;			// Ramp Gen. Current Value
	Uint16				TEST;				// Test Register
	Uint16				rsvd9[2]		;	// Reserved
};

//---------------------------------------------------------------------------
// Comp External References & Function Declarations:
//
extern volatile struct COMP_REGS Comp1Regs;
extern volatile struct COMP_REGS Comp2Regs;
extern volatile struct COMP_REGS Comp3Regs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of F2806x_COMP_H definition
//===========================================================================
// End of file.
//===========================================================================
