//###########################################################################
//
// FILE:   F2806x_Devemu.h
//
// TITLE:  F2806x Device DEVEMU Register Definitions.
//
//###########################################################################
// $TI Release:   $
// $Release Date:   $
//###########################################################################

#ifndef F2806x_DEVEMU_H
#define F2806x_DEVEMU_H

#ifdef __cplusplus
extern "C" {
#endif


//---------------------------------------------------------------------------
// DEVEMU Individual Register Bit Definitions:

struct DEVICECNF_BITS {     // bits description
	Uint16	rsvd1:3;			// 2:0	Reserved
	Uint16	VMAPS:1;			// 3	VMAP Configure Status
	Uint16	rsvd2:1;			// 4	Reserved
	Uint16	XRSn:1;				// 5	Reset Input Signal Status
	Uint16	rsvd3:13;			// 18:6	Reserved
	Uint16	ENPROT:1;			// 19	Enable Write-Read Protection Mode Bit
	Uint16	MONPRIV:1;			// 20	MONPRIV Enable Bit
	Uint16	rsvd4:6;			// 26:21	Reserved
	Uint16	TRSTn:1;			// 27	Read Status of TRSTn Signal
	Uint16	rsvd5:2;			// 29:28	Reserved
	Uint16	rsvd6:1;			// 30	Reserved
	Uint16	rsvd7:1;			// 31	Reserved
};

union DEVICECNF_REG {
	Uint32 all;
	struct DEVICECNF_BITS	bit;
};

struct PARTID_BITS {     // bits description
	Uint16	PARTNO:8;			// 7:0	Part Number
	Uint16	PARTTYPE:8;			// 15:8	Part Type
};

union PARTID_REG {
	Uint16 all;
	struct PARTID_BITS	bit;
};

struct DEV_EMU_REGS {
	union	DEVICECNF_REG	DEVICECNF;	// Device Configuration Register
	union	PARTID_REG		PARTID;		// PARTID/CLASSID Register
	Uint16					REVID;		// Revision ID Register
};

//---------------------------------------------------------------------------
// Devemu External References & Function Declarations:
//
extern volatile struct DEV_EMU_REGS DevEmuRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of F2806x_DEVEMU_H definition
//===========================================================================
// End of file.
//===========================================================================
