;******************************************************************************
; FILE PURPOSE: Module for CRC-8 calculation
;******************************************************************************
;
; FILE NAME: crc8_vcu.asm
;
; DESCRIPTION:
;  This file contains the functions to do the CRC8 using VCU
;   polynomial  = 0x07
;  Copyright (c) 2010 Texas Instruments Inc.
;  All Rights Reserved This program is the confidential and proprietary
;  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
;  transfer of this program is strictly prohibited.
;
; HISTORY:
;
;  03/02/2010  : LoriH initial implementation for VCU
;  10/25/2010  : Gary Xu, ported to PLC

;======================================================================
; void getCRC8_vcu() - see above       
;======================================================================
; Input parameters:
;   ACC       input_crc8_accum: the init value of crc, in case the message has been
;                  chopped into several parts, you can use the crc8 of the previous
;                  segment as the init value for the current segment crc8 calculation
;                  until the final crc is derived.
;   *+XAR4   msg         : pointer of the word stream of the message
;   AR5      parity      : ODD or EVEN to tell the starting byte in the word stream
;   *-SP[1]/AR0   rxLen  : number of BYTES of the input msg
;
; Output parameters:
;   AL        8-bit CRC checksum
;======================================================================
      
      .def _getCRC8_vcu_asm
      .sect   "phyRamFuncs"
      
_getCRC8_vcu_asm:
      PUSH        XAR0
      PUSH        XAR1
      
      MOVZ        AR0, *-SP[7]       ; load rxLen
      ADDB        SP, #4              ; allocate 4 words for local
      VMOV32      *-SP[2], VCRC       ; Store current CRC
      VCRCCLR    
      MOV         *-SP[4], ACC
      VMOV32      VCRC,*-SP[4]        ; VCRC = Inital value
      MOV         AL, AR5              ; check the parity       
      SBF         _CRC8_loop_prep, EQ
      VCRC8H_1    *XAR4++             ; if parity=1, calculate high byte first
      DEC         AR0            
      SBF         _CRC8done, EQ
      
_CRC8_loop_prep:      
      MOV         AL, AR0
      MOV         AH, AR0
      AND         AL, #0xFFF8         ; check to see if the length is greater than 8 bytes
      BF          _CRC8_LSB,EQ
      LSR         AL, #3              ; loop in 8 bytes
      MOV         AR1, AL
      SUB         AR1, #1
      
      .align     (2)                  ; align at 32-bit boundary to remove penalty
      RPTB        _CRC8_post, AR1  ; loop for the middle part of the packet
      VCRC8L_1   *XAR4               
      VCRC8H_1   *XAR4++ 
      VCRC8L_1   *XAR4               
      VCRC8H_1   *XAR4++ 
      VCRC8L_1   *XAR4               
      VCRC8H_1   *XAR4++ 
      VCRC8L_1   *XAR4               
      VCRC8H_1   *XAR4++ 
_CRC8_post      

      LSL         AL, #3              ; calculating remaining number of bytes
      SUB         AH, AL
      SBF         _CRC8done, EQ    ; if multiple of 8, done
      MOV         AR0, AH   
           
_CRC8_LSB
      VCRC8L_1    *XAR4               ; if parity=0, calculate the low byte
      DEC         AR0       
      SBF         _CRC8done, EQ
      VCRC8H_1    *XAR4++
      DEC         AR0       
      SBF         _CRC8_LSB, NEQ
_CRC8done
      VMOV32       *-SP[4], VCRC        ; Store CRC
      MOV          AL, *-SP[4]          ; return AL 
      VMOV32       VCRC, *-SP[2]        ; Restore VCRC
      SUBB         SP, #4               ; restore stack pointer
      POP          XAR1
      POP          XAR0
      LRETR
      
