/******************************************************************************
* FILE PURPOSE: This file implements the G3 PHY TX/RX Test
*******************************************************************************
*
* FILE NAME: test_tx_rx.c
* DESCRIPTION:
*
*  Copyright (c) 2008 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 03/03/2008, MFU, Initial version
* Functions:
*
*
******************************************************************************/
/* configuration file */
#ifdef F2806X
  #include <test_tx_rx_f2806xcfg.h>
#elif defined (F28M35X)
  #include <test_tx_rx_f28m35xcfg.h>
#else
  #include <test_tx_rxcfg.h>
#endif

#include "DSP28x_Project.h"

#include <phy_rx.h>
#include <phy_tx.h>
#include <phy_test.h>
#include <hal_afe.h>
#include <phy_tx_swi.h>

UINT16 getCRC8(uint16 input_crc8_accum, uint16 *msg, parity_t parity, uint16 rxLen);
UINT16 getCRC8_vcu_asm(uint32 input_crc8_accum, uint16 *msg, parity_t parity, uint16 rxLen);

#define PHY_TX_TEST_BUF_SIZE 120

UINT16 PHY_tx_testBuf[PHY_TX_TEST_BUF_SIZE];
void ledBlink_gpio31();

PHY_tx_ppdu_t PHY_tx_ppdu_s =
{
  0,  //*ppdu
  73, //len
  16, //lev
  0,  //mcs
  0,  //tm
  {0, 0}, //txgain
  0,       // dt
  0,       // rpt
  0        // txTime
};

#ifdef P1901_2_FCC
PHY_txSetData_t test_toneMask_s =
{
  0xC81F,
  0xFFFF,
  0xFFFF,
  0xFFFF,
  0xFFFF,
  0x00FF,
  0x0000
};
#else
PHY_txSetData_t test_toneMask_s =
{
  0x2417,
  0xFFFF,
  0xFFFF,
  0x000F,
  0x0000,
  0x0000,
  0x0000
};
#endif


void flash_setup(void);
void sys_init_phy_rx(void);
void sys_init_phy_tx(void);
void PHY_tx_sema_post();

extern void cb_bit(PHY_ev_t eventID, PHY_cbData_t *cbData_p);
void cb_tx(PHY_ev_t eventID, PHY_cbData_t *data_p);
void cb_ppdu(PHY_ev_t eventID, PHY_cbData_t *cbData_p);

UINT32 idle_cnt=0;
#ifdef P1901_2_FCC
 UINT32 test_toneMap = 0xFFFFFF;
#else
 UINT32 test_toneMap = 0x003F;
#endif
UINT16 test_toneCoef[2] = {0x0000, 0x0000};//each 4-bit field is 2-compliment gain

/******************************************************************************
* FUNCTION NAME: sys_init
*
* DESCRIPTION:
*
*
* Return Value:
*
* Input Parameters:
*
* Output Parameters:
*
* Functions Called:

******************************************************************************/
void sys_init_hw(void)
{
  // Step 1. Initialize System Control:
  // PLL, WatchDog, enable Peripheral Clocks
  // This example function is found in the DSP2833x_SysCtrl.c file.

  DINT;     // Global Disable all Interrupts
  IER = 0x0000;         // Disable CPU interrupts
  IFR = 0x0000;         // Clear all CPU interrupt flags

  // Step 1. Initialize System Control:
  // PLL, WatchDog, enable Peripheral Clocks
  // This example function is found in the DSP2833x_SysCtrl.c file.
  InitSysCtrl();

  /* Map ePWM registers to PF3 */
  EALLOW;
//  SysCtrlRegs.MAPCNF.bit.MAPEPWM = 1;
  EDIS;

  // Step 1a. Reset peripherals
  DMAInitialize();

  // RLiang TX-PHY need this one
  InitCpuTimers();

  // Specific clock setting for this example:
  //EALLOW;
  //SysCtrlRegs.HISPCP.all = ADC_MODCLK;    // HSPCLK = SYSCLKOUT/ADC_MODCLK
  //EDIS;

  // Step 2. Initialize GPIO:
  // This example function is found in the DSP2833x_Gpio.c file and
  // illustrates how to set the GPIO to it's default state.
  // InitGpio();  // Skipped for this example

  // Step 3. Clear all interrupts and initialize PIE vector table:
  // Disable CPU interrupts
  DINT;

  // Initialize the PIE control registers to their default state.
  // The default state is all PIE interrupts disabled and flags
  // are cleared.
  // This function is found in the DSP2833x_PieCtrl.c file.
  InitPieCtrl();

  // Disable CPU interrupts and clear all CPU interrupt flags:
  IER = 0x0000;
  IFR = 0x0000;

  // Initialize the PIE vector table with pointers to the shell Interrupt
  // Service Routines (ISR).
  // This will populate the entire table, even if the interrupt
  // is not used in this example.  This is useful for debug purposes.
  // The shell ISR routines are found in DSP2833x_DefaultIsr.c.
  // This function is found in DSP2833x_PieVect.c.
  //InitPieVectTable();

}

/***********************************************************************/
/* Call back for PHY_rxPpdu BitDone                                           */
/***********************************************************************/
Uint16 rxppdu_cnt = 0;
void cb_ppdu(PHY_ev_t eventID, PHY_cbData_t *cbData_p)
{
  if (cbData_p->status == PHY_STAT_SUCCESS)
    {
      rxppdu_cnt++;

      /* Start TX PPDU */
      PHY_txPreparePpdu(&PHY_tx_ppdu_s, cb_tx);
      PHY_txPpdu(&PHY_tx_ppdu_s, cb_tx);

      /* blink led every 8 pkt for testing */
       //  if ((rxppdu_cnt & 0x7) == 0)
       // GpioDataRegs.GPATOGGLE.bit.GPIO31 = 1;
    }
}

/* TX Callback */
Uint16 cb_ev=0, txppdu_cnt=0;
void cb_tx(PHY_ev_t eventID, PHY_cbData_t *data_p)
{
  cb_ev = eventID;

  txppdu_cnt++;

  /* flash led every 8 pkt for testing */
  if ((txppdu_cnt & 0x7) == 0)
    ledBlink_gpio31();
    // GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;

  //SEM_post(&PHY_TX_TEST_SEM);
}

/******************************************************************************
* FUNCTION NAME: main
*
* DESCRIPTION:
*
*
* Return Value:
*
* Input Parameters:
*
* Output Parameters:
*
* Functions Called:

******************************************************************************/
void main(Void)
{
  PHY_rxTestMode_t rxTestMode;
  HAL_afe_prfParms_t afePrfParms;

  Uint16 idx;

  for (idx = 0; idx < (PHY_TX_TEST_BUF_SIZE); idx++)
  {
      PHY_tx_testBuf[idx] = ((((idx & 127) << 1) + 1) << 8) | ((idx & 127) << 1);
  }

  /* initialize HW */
  sys_init_hw();

  /* setup for flash */
  flash_setup();

  /* init LED */
  //LED_init();

  EALLOW;

#if defined (F28M35X)
   GpioG1CtrlRegs.GPCMUX1.bit.GPIO71  = 0;          // 0=GPIO
   GpioG1CtrlRegs.GPCDIR.bit.GPIO71   = 1;          // 1=OUTput,  0=INput
   GpioG1CtrlRegs.GPCQSEL1.bit.GPIO71 = 1;          // uncomment if --> Set High initially
#else

  GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0; //0-GPIO
  GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1; //1-output
  // GpioCtrlRegs.GPAMUX2.bit.GPIO31 = 0; //0-GPIO
  // GpioCtrlRegs.GPADIR.bit.GPIO31 = 1; //1-output
  GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 0; //0-GPIO
  GpioCtrlRegs.GPADIR.bit.GPIO6 = 1; //1-output
  GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 0; //0-GPIO
  GpioCtrlRegs.GPADIR.bit.GPIO7 = 1; //1-output
  GpioCtrlRegs.GPAMUX1.bit.GPIO8 = 0; //0-GPIO
  GpioCtrlRegs.GPADIR.bit.GPIO8 = 1; //1-output
#endif
  EDIS;

  /* HAL profile (tx/rx sampling and PWM frequencies */
#ifdef AFE031
    /* AFE031 requires 3x TX sampling rate */
    afePrfParms.tx_fs_kHz = HAL_AFE_KHZ_1200;
#else
  afePrfParms.rx_fs_kHz = HAL_AFE_KHZ_400;
  afePrfParms.tx_fs_kHz = HAL_AFE_KHZ_400;
  afePrfParms.tx_pwm_kHz = HAL_AFE_KHZ_1200;
#endif

#if defined(CENELEC_B) || defined(CENELEC_BC)
  afePrfParms.band = 1;
#else
  afePrfParms.band = 0;
#endif

  HAL_afeInit(&afePrfParms);

  /* init PHY Rx */
  sys_init_phy_rx();

  /* Set up for test */
  rxTestMode.flags = 1;
  rxTestMode.dataPattern = PHY_TEST_DATA_RAMP;
  PHY_rxSetTestMode(&rxTestMode);

  /* init PHY TX */
  sys_init_phy_tx();

  /* Set tonemask */
  PHY_txSet(PHY_TX_SET_TONEMASK, (PHY_txSetData_t *)&test_toneMask_s);
  PHY_rxSet(PHY_RX_SET_TONEMASK, (PHY_rxSetData_t *)&test_toneMask_s);

  // initialize PHY band and reconfigure the afe parameters
  PHY_init();

  /* Start PHY Rx */
  PHY_rxStart(0xFFFF, cb_ppdu);

  /* Register for bit start */
  PHY_rxBitStartIndicate(cb_bit);

  PHY_txPpduStartCbReg(PHY_tx_mbx_post);

  PHY_tx_ppdu_s.ppdu_p = PHY_tx_testBuf;
  PHY_tx_ppdu_s.toneMap = test_toneMap;

  PHY_tx_ppdu_s.txGain[0] = test_toneCoef[0];
  PHY_tx_ppdu_s.txGain[1] = test_toneCoef[1];

  /* enable sys interrupt */
  EnableInterrupts();

  PHY_txPreparePpdu(&PHY_tx_ppdu_s, cb_tx);
  // generate preamble
  PHY_txSmRun(0);
  PHY_txPpdu(&PHY_tx_ppdu_s, cb_tx);

}



Uint32 blinkCnt=0;
void ledBlink_gpio31()
{
#ifdef F28M35X
   // silicon errata: sprz357.pdf
   if(GpioG1DataRegs.GPCDAT.bit.GPIO71 == 0){
   	 GpioG1DataRegs.GPCSET.bit.GPIO71 = 1;
   }else{
   	 GpioG1DataRegs.GPCCLEAR.bit.GPIO71 = 1;
   }
#else
    GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;
#endif
  blinkCnt++;
}

// CRC8 convertion function
uint16 getCRC8 (uint16 input_crc8_accum, uint16 * msg, parity_t parity,
    uint16 rxLen)
{
  return getCRC8_vcu_asm(input_crc8_accum, msg, parity, rxLen);
}
