/*****************************************************************************
* FILE PURPOSE: This file implements PTXM Thread Functions
*******************************************************************************
*
* FILE NAME: PHY_tx_thread.c
*
* DESCRIPTION:
*       This file contains functions used for PHY TX OS thread related functions.
*       Note: This file is not included in the PHY library. User is expected 
*             to provide OS hooks.
*
*  Copyright (c) 2009 Texas Instruments Inc.
*  All Rights Reserved This program is the confidential and proprietary
*  product of Texas Instruments Inc.  Any Unauthorized use, reproduction or
*  transfer of this program is strictly prohibited.
*
* HISTORY:
*
* 03/10/2009 fum    Written
*
* LIST OF FUNCTIONS:
*
*
******************************************************************************/
#include <phy_tx.h>
#include <phy_tx_swi.h>
#include <hal_afe.h>
#ifdef F2806X
  #include <test_tx_rx_f2806xcfg.h>
#elif defined (F28M35X)
  #include <test_tx_rx_f28m35xcfg.h>
#else
  #include <test_tx_rxcfg.h>
#endif

//void PHY_tx_sema_post();
//void PHY_tx_sema_reg(PHY_tx_sema_post_func_t func_p);
/******************************************************************************
* FUNCTION NAME: PHY_tx_thread
*
* DESCRIPTION:   PHY TX thread for bit processing. Lower priority.
*
* Return Value:  None
*
* Input Parameters:
*
* Output Parameters:
* Functions Called:
*
******************************************************************************/
void PHY_tx_thread()
{  
  PHY_txMsg_t phyTxMsg;
  // may have problem
  PHY_txPpduStartCbReg(PHY_tx_mbx_post);

  while(1)
  { 
    MBX_pend(&PHY_TX_QUE, &phyTxMsg, SYS_FOREVER);
    
    if (phyTxMsg.stage == 0)
    {
      // generate preamble
      PHY_txSmRun(0);
    }
    else if (phyTxMsg.stage == 1)
    {
      // call PHY library API for bit processing
#ifndef P1901_2_FCC
      // F28069 FCC band: process the bit level in txPpdu for MIPS savings
      if (PHY_handle_s.band < PHY_MODE_FCC)
#endif
         PHY_txSmRun(1);
    }
  }
}
/******************************************************************************
* FUNCTION NAME: PHY_tx_swi_proc
*
* DESCRIPTION:   PHY TX SWI for symbol processing state machine. High priority.
*
* Return Value:  None
*
* Input Parameters:
*
* Output Parameters:
* Functions Called:
*
******************************************************************************/
Uint32 swiCnt=0;
void PHY_tx_swi_proc(void)
{
  // call PHY library API for symbol processing state machine
  PHY_txSmRun(2);
  swiCnt++;
}

/******************************************************************************
* FUNCTION NAME: PHY_tx_dma_bios_isr
*
* DESCRIPTION:   PHY TX DMA interrupt service routine (ISR).
*                This ISR posts PHY_TX_SWI for symbol processing.
*
* Return Value:  None
*
* Input Parameters:
*
* Output Parameters:
* Functions Called:
*
******************************************************************************/
void PHY_tx_dma_bios_isr(void)
{

  // call HAL library API
  HAL_afeTxDmaCh2IntFunc();

  // post SWI
  SWI_post(&PHY_TX_SWI);        
}

/******************************************************************************
* FUNCTION NAME: PHY_tx_sema_post
*
* DESCRIPTION:   PHY TX semaphore post.
*
* Return Value:  None
*
* Input Parameters:
*
* Output Parameters:
* Functions Called:
*
******************************************************************************/
void PHY_tx_mbx_post(PHY_ev_t eventID, PHY_cbData_t *cbData_p)
{  
  PHY_txMsg_t phyTxMsg;
  
  phyTxMsg.stage = cbData_p->cbParms.txStage.stage;

  MBX_post(&PHY_TX_QUE, &phyTxMsg, 0);
}

void sys_init_phy_tx()
{
  /* Initialize PHY TX and HAL TX HW */
  PHY_txInit();
}

