#include "F2806x_Cla_typedefs.h"
#include "F2806x_SysCtrl.h"
#include "F2806x_Gpio.h"
#include "F2806x_PieCtrl.h"
#include "F2806x_Device.h"


volatile struct GPIO_CTRL_REGS GpioCtrlRegs;
volatile struct GPIO_DATA_REGS GpioDataRegs;
volatile struct PIE_CTRL_REGS PieCtrlRegs;


/**
 * main.c
 */
int main(void)
{
    InitSysCtrl();
    EALLOW;
            //
            // Each GPIO pin can be:
            // a) a GPIO input/output
            // b) peripheral function 1
            // c) peripheral function 2
            // d) peripheral function 3
            // By default, all are GPIO Inputs
            //
            GpioCtrlRegs.GPAMUX1.all = 0x0000;    // GPIO functionality GPIO0-GPIO15
            GpioCtrlRegs.GPAMUX2.all = 0x0030;    // GPIO functionality GPIO16-GPIO31
            GpioCtrlRegs.GPBMUX1.all = 0x0000;    // GPIO functionality GPIO32-GPIO47
            GpioCtrlRegs.GPBMUX2.all = 0x0000;    // GPIO functionality GPIO48-GPIO63

            //
            // Dig.IO funct. applies to AIO2,4,6,10,12,14
            //
            GpioCtrlRegs.AIOMUX1.all = 0x0000;

            GpioDataRegs.GPADAT.all = 0;
            GpioDataRegs.GPBDAT.all = 0;

            GpioCtrlRegs.GPADIR.all = 0x0000;    // GPIO0-GPIO31 are GP inputs
            GpioCtrlRegs.GPBDIR.all = 0x0001;    // GPIO32-GPIO63 are inputs

            GpioCtrlRegs.GPBCTRL.all = 0x0000;

            //
            // AIO2,4,6,10,12,14 are digital inputs
            //
            GpioCtrlRegs.AIODIR.all = 0x0000;

            //
            // Each input can have different qualification
            // a) input synchronized to SYSCLKOUT
            // b) input qualified by a sampling window
            // c) input sent asynchronously (valid for peripheral inputs only)
            //
            GpioCtrlRegs.GPAQSEL1.all = 0x0000;   // GPIO0-GPIO15 Synch to SYSCLKOUT
            GpioCtrlRegs.GPAQSEL2.all = 0x0000;   // GPIO16-GPIO31 Synch to SYSCLKOUT
            GpioCtrlRegs.GPBQSEL1.all = 0x0000;   // GPIO32-GPIO47 Synch to SYSCLKOUT
            GpioCtrlRegs.GPBQSEL2.all = 0x0000;   // GPIO48-GPIO63 Synch to SYSCLKOUT

            //
            // Pull-ups can be enabled or disabled.
            //
            //GpioCtrlRegs.GPAPUD.all = 0x0000;      // Pullup's enabled GPIO0-GPIO31
            //GpioCtrlRegs.GPBPUD.all = 0x0000;      // Pullup's enabled GPIO32-GPIO44
            GpioCtrlRegs.GPAPUD.all = 0xFFFF;    // Pullup's disabled GPIO0-GPIO31
            GpioCtrlRegs.GPBPUD.all = 0xFFFF;    // Pullup's disabled GPIO32-GPIO44
            EDIS;

            //
                       // Disable the PIE
                       //
                       PieCtrlRegs.PIECTRL.bit.ENPIE = 0;

                       //
                       // Clear all PIEIER registers
                       //
                       PieCtrlRegs.PIEIER1.all = 0;
                       PieCtrlRegs.PIEIER2.all = 0;
                       PieCtrlRegs.PIEIER3.all = 0;
                       PieCtrlRegs.PIEIER4.all = 0;
                       PieCtrlRegs.PIEIER5.all = 0;
                       PieCtrlRegs.PIEIER6.all = 0;
                       PieCtrlRegs.PIEIER7.all = 0;
                       PieCtrlRegs.PIEIER8.all = 0;
                       PieCtrlRegs.PIEIER9.all = 0;
                       PieCtrlRegs.PIEIER10.all = 0;
                       PieCtrlRegs.PIEIER11.all = 0;
                       PieCtrlRegs.PIEIER12.all = 0;

                       //
                       // Clear all PIEIFR registers
                       //
                       PieCtrlRegs.PIEIFR1.all = 0;
                       PieCtrlRegs.PIEIFR2.all = 0;
                       PieCtrlRegs.PIEIFR3.all = 0;
                       PieCtrlRegs.PIEIFR4.all = 0;
                       PieCtrlRegs.PIEIFR5.all = 0;
                       PieCtrlRegs.PIEIFR6.all = 0;
                       PieCtrlRegs.PIEIFR7.all = 0;
                       PieCtrlRegs.PIEIFR8.all = 0;
                       PieCtrlRegs.PIEIFR9.all = 0;
                       PieCtrlRegs.PIEIFR10.all = 0;
                       PieCtrlRegs.PIEIFR11.all = 0;
                       PieCtrlRegs.PIEIFR12.all = 0;

            //
                // Disable Interrupts at the CPU level
                //
                DINT;

                while (1)
                    {
                        GpioDataRegs.GPBDAT.bit.GPIO32 = 0;
                        //delay_loop();
                        GpioDataRegs.GPBDAT.bit.GPIO32 = 1;
                        //delay_loop();
                    }
}
