//###########################################################################
//
// FILE:	Example_2806xGpioToggle.c
//
// TITLE:	GPIO Toggle Test Example
//
//! \addtogroup f2806x_example_list
//! <h1>GPIO Toggle Test (gpio_toggle)</h1>
//!
//!  \note ALL OF THE I/O'S TOGGLE IN THIS PROGRAM.  MAKE SURE
//!  THIS WILL NOT DAMAGE YOUR HARDWARE BEFORE RUNNING THIS
//!  EXAMPLE.
//!
//!  Three different examples are included. Select the example 
//!  (data, set/clear or toggle) to execute before compiling using
//!  the macros found at the top of the code.   
//!
//!  Each example toggles all the GPIOs in a different way, the first
//!  through writing values to the GPIO DATA registers, the second through
//!  the SET/CLEAR registers and finally the last through the TOGGLE register
//!    
//!  The pins can be observed using Oscilloscope.  
// 
//###########################################################################
// $TI Release:  $
// $Release Date:  $
// $Copyright:
// Copyright (C) 2009-2025 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

//
// Included Files
//
#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File

//
// Defines that select the example to compile in.  Only one example should be 
// set as 1 the rest should be set as 0.
//
#define EXAMPLE1 0  // Use DATA registers to toggle I/O's
#define EXAMPLE2 0  // Use SET/CLEAR registers to toggle I/O's
#define EXAMPLE3 1  // Use TOGGLE registers to toggle I/O's

//
// Function Prototypes
//
void delay_loop(void);
void Gpio_select(void);
void Gpio_example1(void);
void Gpio_example2(void);
void Gpio_example3(void);

//
// Main
//
void main(void)
{
    //
    // Step 1. Initialize System Control:
    // PLL, WatchDog, enable Peripheral Clocks
    // This example function is found in the F2806x_SysCtrl.c file.
    //
    InitSysCtrl();

    //
    // Step 2. Initalize GPIO: 
    // This example function is found in the F2806x_Gpio.c file and
    // illustrates how to set the GPIO to it's default state.
    //
    // InitGpio();  // Skipped for this example

    //
    // For this example use the following configuration
    //
    Gpio_select();	  

    //
    // Step 3. Clear all interrupts and initialize PIE vector table:
    // Disable CPU interrupts
    //
    DINT;

    //
    // Initialize PIE control registers to their default state.
    // The default state is all PIE interrupts disabled and flags
    // are cleared.  
    // This function is found in the F2806x_PieCtrl.c file.
    //
    InitPieCtrl();

    //
    // Disable CPU interrupts and clear all CPU interrupt flags
    //
    //IER = 0x0000;
    //IFR = 0x0000;

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt 
    // Service Routines (ISR).  
    // This will populate the entire table, even if the interrupt
    // is not used in this example.  This is useful for debug purposes.
    // The shell ISR routines are found in F2806x_DefaultIsr.c.
    // This function is found in F2806x_PieVect.c.
    //
    InitPieVectTable();

    //
    // Step 4. Initialize all the Device Peripherals:
    // This function is found in F2806x_InitPeripherals.c
    //
    // InitPeripherals(); // Not required for this example

    //
    // Step 5. User specific code
    //
    #if EXAMPLE1
        //
        // This example uses DATA registers to toggle I/O's
        //
        Gpio_example1();
    #endif  // - EXAMPLE1

    #if EXAMPLE2
        //
        // This example uses SET/CLEAR registers to toggle I/O's
        //
        Gpio_example2();
    #endif

    #if EXAMPLE3
        //
        // This example uses TOGGLE registers to toggle I/O's
        //
        Gpio_example3();
    #endif
} 	

//
// delay_loop - 
//
void
delay_loop()
{
    double i;
    for (i = 0; i < 400000; i++)
    {
        
    }
}

//
// Gpio_example1 - Example 1: Toggle I/Os using DATA registers
//
void
Gpio_example1(void)
{ 

}

//
// Gpio_example2 - Example 2: Toggle I/Os using SET/CLEAR registers
//
void
Gpio_example2(void)
{  

}

//
// Gpio_example3 - Example 2: Toggle I/Os using TOGGLE registers
//
void
Gpio_example3(void)
{ 
    // Set GPIO0 to a known state (e.g., low)
       GpioDataRegs.GPACLEAR.bit.GPIO0 = 1;

       while (1)
       {
           Gpio_toggle_function();
       }
}

void
Gpio_toggle_function(void)
{
    GpioDataRegs.GPATOGGLE.bit.GPIO0 = 1;  // Toggle GPIO0
}

//
// Gpio_select -
//
void
Gpio_select(void)
{
    EALLOW;

        // Set GPIO0 as a GPIO (not peripheral function)
        GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 0;  // GPIO0 = GPIO
        GpioCtrlRegs.GPADIR.bit.GPIO0 = 1;   // GPIO0 = Output

        EDIS;
}
     
//
// End of File
//

