
#include <xdc/std.h>
#include <xdc/runtime/log.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Semaphore.h>

#include "F28x_Project.h"

extern const Semaphore_Handle LedSeM;


void hardware_init(void);
void ledToggle(void);
void Timer_ISr(void);

volatile int ToggleCount = 0;

void main(void)
{
    hardware_init();
    BIOS_start();

}

void hardware_init(void)
{
    InitSysCtrl();
    InitGpio();
    EALLOW;
    GpioCtrlRegs.GPAMUX2.bit.GPIO23 = 0;
    GpioCtrlRegs.GPADIR.bit.GPIO23 = 1;
    EDIS;
    InitCpuTimers();
    ConfigCpuTimer(&CpuTimer0,100,500000);
    CpuTimer0Regs.TCR.all = 0x4001;
}

void ledToggle(void)
{
    while(1)
    {
        Semaphore_pend(LedSeM,BIOS_WAIT_FOREVER);
        GpioDataRegs.GPATOGGLE.bit.GPIO23=1;
        ToggleCount++;
        Log_info1("LED TOGGLED [%u] TIMES",ToggleCount);
    }

}

void Timer_ISr(void)
{
  Semaphore_post(LedSeM);
}

