/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "board.h"

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	LIN_init();

	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	//
	// PinMux for modules assigned to CPU1
	//
	
	//
	// LINA -> myLIN0 Pinmux
	//
	GPIO_setPinConfig(myLIN0_LINRX_PIN_CONFIG);
	GPIO_setPadConfig(myLIN0_LINRX_GPIO, GPIO_PIN_TYPE_STD | GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(myLIN0_LINRX_GPIO, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(myLIN0_LINTX_PIN_CONFIG);
	GPIO_setPadConfig(myLIN0_LINTX_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myLIN0_LINTX_GPIO, GPIO_QUAL_ASYNC);


}

//*****************************************************************************
//
// LIN Configurations
//
//*****************************************************************************
void LIN_init(){
	myLIN0_init();
}

void myLIN0_init(){
    
    //
    // Initialize the LIN Module in LIN mode
    //
    LIN_initModule(myLIN0_BASE);

	//
    // Enter Software Reset State
    //
    LIN_enterSoftwareReset(myLIN0_BASE);
    LIN_setLINMode(myLIN0_BASE, LIN_MODE_LIN_COMMANDER);
    LIN_setCommMode(myLIN0_BASE, LIN_COMM_LIN_USELENGTHVAL);
    LIN_setDebugSuspendMode(myLIN0_BASE, LIN_DEBUG_FROZEN);
    LIN_setChecksumType(myLIN0_BASE, LIN_CHECKSUM_ENHANCED);
    LIN_setMessageFiltering(myLIN0_BASE, LIN_MSG_FILTER_IDRESPONDER);
	LIN_setBaudRatePrescaler(myLIN0_BASE, 650U, 1U);
    LIN_setFrameLength(myLIN0_BASE, 2U);
    LIN_setSyncFields(myLIN0_BASE, 5U, 3U);
    LIN_setTxMask(myLIN0_BASE, (uint16_t)(0xFFU));
    LIN_setRxMask(myLIN0_BASE, (uint16_t)(0xFFU));
    LIN_enableParity(myLIN0_BASE);
    LIN_enableMultibufferMode(myLIN0_BASE);

    //
    // Finally exit SW reset and enter LIN ready state
    //
    LIN_exitSoftwareReset(myLIN0_BASE);
    LIN_enableInterrupt(myLIN0_BASE, LIN_INT_ALL);
}

