
#include "driverlib.h"
#include "device.h"
#include "lin.h"

uint16_t txData[3] = {0x11, 0x22, 0x33};

void main(void)
{
    Device_init();
    Device_initGPIO();

    /* pinmux for LIN A */
    GPIO_setPinConfig(DEVICE_GPIO_CFG_LINTXA);
    GPIO_setPinConfig(DEVICE_GPIO_CFG_LINRXA);

    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_LINA);

    /* Initialize LIN module and set commander mode */
    LIN_initModule(LINA_BASE);
    LIN_setLINMode(LINA_BASE, LIN_MODE_LIN_COMMANDER);

    /* (Optional) enable parity if you want parity bits checked on the bus */
    LIN_enableParity(LINA_BASE);

    /* build ID with parity bits */
    uint16_t id = LIN_generateParityID(0x12);    // 0x12 is your 6-bit ID

    /* Frame length = 3 bytes */
    LIN_setFrameLength(LINA_BASE, 3U);

    while(1)
    {
        /* Set the ID byte (writing it initiates the header transmit in commander mode) */
        LIN_sendData(LINA_BASE, txData);
        LIN_setIDByte(LINA_BASE, id);

        /* Send data block (sends the response field after the header) */

        /* Wait for TX buffer to be ready before next transaction */
        while(!LIN_isTxReady(LINA_BASE)) { /* spin */ }

        DEVICE_DELAY_US(1000000); // 1 s between frames
    }
}