// The user must define CLA_C in the project linker settings if using the
// CLA C compiler
// Project Properties -> C2000 Linker -> Advanced Options -> Command File
// Preprocessing -> --define
--define=CLA_C=1
--define=CLA_MATH_TABLES_IN_ROM=1

#ifdef CLA_C
// Define a size for the CLA scratchpad area that will be used
// by the CLA compiler for local symbols and temps
// Also force references to the special symbols that mark the
// scratchpad are.
CLA_SCRATCHPAD_SIZE = 0x400;
--undef_sym=__cla_scratchpad_end
--undef_sym=__cla_scratchpad_start
#endif //CLA_C

MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   BEGIN           	: origin = 0x080000, length = 0x000002
   RAMM0           	: origin = 0x000080, length = 0x000380
   RAMD0           	: origin = 0x00B000, length = 0x000800

   RAMLS0          	: origin = 0x008000, length = 0x002000 //Ethernet
   /*RAMLS1          	: origin = 0x008800, length = 0x000800
   RAMLS2      		: origin = 0x009000, length = 0x000800
   RAMLS3      		: origin = 0x009800, length = 0x000800*/
   RAMLS4      		: origin = 0x00A000, length = 0x001000 //Ethernet
//   RAMLS5           : origin = 0x00A800, length = 0x000800/*SK CLA 22/10*/

   RAMGS14          : origin = 0x01A000, length = 0x001000
   RAMGS15          : origin = 0x01B000, length = 0x001000
   RESET       		: origin = 0x3FFFC0, length = 0x000002

   /* Flash sectors */
   FLASHA           : origin = 0x080002, length = 0x001FFE	/* on-chip Flash */
   FLASHB           : origin = 0x082000, length = 0x002000	/* on-chip Flash */
   FLASHC           : origin = 0x084000, length = 0x002000	/* on-chip Flash */
   FLASHD           : origin = 0x086000, length = 0x002000	/* on-chip Flash */
   FLASHE           : origin = 0x088000, length = 0x030000	/* on-chip Flash */
//   FLASHF           : origin = 0x090000, length = 0x008000	/* on-chip Flash */
//   FLASHG           : origin = 0x098000, length = 0x008000	/* on-chip Flash */
//   FLASHH           : origin = 0x0A0000, length = 0x008000	/* on-chip Flash */
//   FLASHI           : origin = 0x0A8000, length = 0x008000	/* on-chip Flash */
//   FLASHJ           : origin = 0x0B0000, length = 0x008000	/* on-chip Flash */
   FLASHK           : origin = 0x0B8000, length = 0x002000	/* on-chip Flash */
   FLASHL           : origin = 0x0BA000, length = 0x002000	/* on-chip Flash */
   FLASHM           : origin = 0x0BC000, length = 0x002000	/* on-chip Flash */
   FLASHN           : origin = 0x0BE000, length = 0x002000	/* on-chip Flash */

PAGE 1 :

   BOOT_RSVD       : origin = 0x000002, length = 0x00007E     /* Part of M0, BOOT rom will use this for stack */
   RAMM1           : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */
   RAMD1           : origin = 0x00B800, length = 0x000800

   RAMGS0      : origin = 0x00C000, length = 0x005000
   //RAMGS1      : origin = 0x00D000, length = 0x001000
   //RAMGS2      : origin = 0x00E000, length = 0x001000
   //RAMGS3      : origin = 0x00F000, length = 0x001000
   //RAMGS4      : origin = 0x010000, length = 0x001000
   RAMGS5      : origin = 0x011000, length = 0x002000
   //RAMGS6      : origin = 0x012000, length = 0x001000

   RAMGS7      : origin = 0x013000, length = 0x002000
   //RAMGS8      : origin = 0x014000, length = 0x001000
   RAMGS9      : origin = 0x015000, length = 0x002000
   //RAMGS10     : origin = 0x016000, length = 0x001000
   RAMGS11     : origin = 0x017000, length = 0x003000
   //RAMGS12     : origin = 0x018000, length = 0x001000
   //RAMGS13     : origin = 0x019000, length = 0x001000

   CPU2TOCPU1RAM   : origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM   : origin = 0x03FC00, length = 0x000400
   
}


SECTIONS
{
   /* Allocate program areas: */
   .cinit              : > FLASHE      PAGE = 0, ALIGN(4)
   .pinit              : > FLASHE,     PAGE = 0, ALIGN(4)
   .text               : > FLASHE      PAGE = 0, ALIGN(4)
   codestart           : > BEGIN       PAGE = 0, ALIGN(4)
   ramfuncs            : LOAD = FLASHE,
                         RUN = RAMLS0,
                         LOAD_START(_RamfuncsLoadStart),
                         LOAD_SIZE(_RamfuncsLoadSize),
                         LOAD_END(_RamfuncsLoadEnd),
                         RUN_START(_RamfuncsRunStart),
                         RUN_SIZE(_RamfuncsRunSize),
                         RUN_END(_RamfuncsRunEnd),
                         PAGE = 0, ALIGN(4)
						 
   /* Allocate uninitalized data sections: */
   .stack              : > RAMM1        PAGE = 1
   //.ebss               : > RAMLS5       PAGE = 1
   //.esysmem            : > RAMLS5       PAGE = 1
   .ebss               : > RAMLS0       PAGE = 0	//37.01.00.7.12
   .esysmem            : > RAMLS0       PAGE = 0

   /* Initalized sections go in Flash */
   .econst             : > FLASHA | FLASHB      PAGE = 0, ALIGN(4)
   .switch             : > FLASHA | FLASHB      PAGE = 0, ALIGN(4)
   .reset           : > RESET,     PAGE = 0, TYPE = DSECT /* not used, */


   /* CLA specific sections */ //Ethernet	//37.01.00.7.12
#if !(CLA_MATH_TABLES_IN_ROM)
   CLA1mathTables   : > RAMLS0,                 PAGE = 0

   //Load tables to Flash and copy over to RAM -- CLA Math Tables in ROM
   CLA1mathTables   :  LOAD = FLASHB,
                       RUN = RAMLS0,
                       RUN_START(_CLA1mathTablesRunStart),
                       LOAD_START(_CLA1mathTablesLoadStart),
                       LOAD_SIZE(_CLA1mathTablesLoadSize),
                       PAGE = 0
#endif //CLA_MATH_TABLES_IN_ROM

   Cla1Prog         : LOAD = FLASHD,
                      RUN = RAMLS4,
                      LOAD_START(_Cla1funcsLoadStart),
                      LOAD_END(_Cla1funcsLoadEnd),
                      RUN_START(_Cla1funcsRunStart),
                      LOAD_SIZE(_Cla1funcsLoadSize),
                      PAGE = 0, ALIGN(4)

	/*SK CLA 22/10
	Cla1Prog1       : LOAD = FLASHK,
                      RUN = RAMLS5,
                      LOAD_START(_Cla1funcsLoadStart1),
                      LOAD_END(_Cla1funcsLoadEnd1),
                      RUN_START(_Cla1funcsRunStart1),
                      LOAD_SIZE(_Cla1funcsLoadSize1),
                      PAGE = 0, ALIGN(4) */

   #ifdef CLA_C
   /* CLA C compiler sections */
   // Must be allocated to memory the CLA has write access to
   CLAscratch       :
                     { *.obj(CLAscratch)
                     . += CLA_SCRATCHPAD_SIZE;
                     *.obj(CLAscratch_end) } >  RAMLS0,  PAGE=0

   .scratchpad      : > RAMLS0,       PAGE=0
   .bss_cla		    : > RAMLS0,       PAGE=0
   .const_cla	    :  LOAD = FLASHB,
                       RUN = RAMLS0,
                       RUN_START(_Cla1ConstRunStart),
                       LOAD_START(_Cla1ConstLoadStart),
                       LOAD_SIZE(_Cla1ConstLoadSize),
                       PAGE = 0, ALIGN(4)
	#endif //CLA_C
  
   SHARERAMGS0		: > RAMGS0,		PAGE = 1
   SHARERAMGS1		: > RAMGS0,		PAGE = 1
   
   /* The following section definitions are required when using the IPC API Drivers */ 
    GROUP : > CPU2TOCPU1RAM, PAGE = 1 
    {
        PUTBUFFER 
        PUTWRITEIDX 
        GETREADIDX 
    }
    
    GROUP : > CPU1TOCPU2RAM, PAGE = 1
    {
        GETBUFFER :    TYPE = DSECT
        GETWRITEIDX :  TYPE = DSECT
        PUTREADIDX :   TYPE = DSECT
    }  

       /* Allocate IQ math areas: */ //37.00
   IQmath			: > FLASHB, PAGE = 0, ALIGN(4)            /* Math Code */
   IQmathTables		: > FLASHC, PAGE = 0, ALIGN(4)
    
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
