/*
 * MAIN2.c
 *
 *  Created on: 23-Apr-2025
 *      Author: Jenson J
 */



// Included Files
#include "F28x_Project.h"
#include "math.h"

//defines
//defines
#define Tsample 0.00002     // Sampling time = 20e-6s
#define TB_CLK    200e6            //TBCLK = EPWMCLK = SYSCLK/2 (default); SYSCLK = 200 MHz
#define PWM_CLK   50e3              // 50kHz carrier frequency
#define TB_Period TB_CLK/(PWM_CLK)     //TB_Period = TB_CLK/(PWM_CLK)
#define TwoPiByThree  2.094395102
#define Pi 3.141592654


// Globals
int n = 0, cnt=0, PHASE_SHIFT= TB_Period/2, PHASE_SHIFT_Default= TB_Period/2;
float ma = 0.0, mb = 0.0, mc = 0.0, md = 0.0, me = 0.0;
float m = 0.9, omega = 314.1592654, phi=20.0;
float buff1[500];

// Function Prototypes
void GPIOConfig(void);
void EPwmConfig(void);
interrupt void Timer0_isr(void);

// Main

void main(void)
{
    //1. Initialize System Control: PLL, WatchDog, disable Peripheral Clocks (F2837xD_SysCtrl.c)
      InitSysCtrl();  // SYSCLK = 200 MHz (Using INTOSC2 = 10 MHz)

    //2. Initialize GPIO: [CPU1 only] Disable pin locks, Fill all (6 GPIO ports) registers with zeros.(F2837xD_Gpio.c)
    InitGpio();

    // GPIO muxed Peripherals
    GPIOConfig();

    DINT;
    //3. Clear all __interrupts and initialize PIE vector table Disable CPU __interrupts (F2837xD_device.h)
    //DINT;

    //Initialize PIE control registers to their default state. The default state is all PIE __interrupts disabled and flags are cleared (F2837xD_PieCtrl.c)
    InitPieCtrl();

    // Disable CPU __interrupts and clear all CPU __interrupt flags:
    IER = 0x0000;
    IFR = 0x0000;

    InitPieVectTable();

    //Required Interrupts are re-mapped to ISR functions.
    EALLOW;
    PieVectTable.TIMER0_INT = &Timer0_isr;
    //PieVectTable.EPWM1_INT = &Timer0_isr;
    EDIS;

    InitCpuTimers();

    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC =0; // STOP counter TBCTR
    // enable peripheral clocks
    CpuSysRegs.PCLKCR0.bit.CPUTIMER0 =1;
    CpuSysRegs.PCLKCR2.bit.EPWM1=1;
    CpuSysRegs.PCLKCR2.bit.EPWM2=1;
    CpuSysRegs.PCLKCR2.bit.EPWM3=1;
    CpuSysRegs.PCLKCR2.bit.EPWM4=1;
    CpuSysRegs.PCLKCR2.bit.EPWM5=1;
   //CpuSysRegs.PCLKCR2.bit.EPWM6=1;
    EDIS;

    EPwmConfig();

    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC =1; // When set PWM time bases of all the PWM modules belonging to the same CPU-Subsystem (as partitioned using their CPUSEL bits) start counting.
    EDIS;

    // Configure CPU-Timer0 to interrupt every (Tsample) 20 uSeconds: 200MHz CPU Freq
    ConfigCpuTimer(&CpuTimer0, 200, 20);

    CpuTimer0Regs.TCR.all = 0x4000;

    // Enable Interrupts. Enable CPU INT1(Group 1)
    IER |= M_INT1;
    // Enable TINT1 in the PIE: Group 1 Interrupt 7 (TIMER0)


    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;


    EINT;
    ERTM;

    PHASE_SHIFT=(phi-30)*TB_Period/360;
     for(;;);
}

interrupt void Timer0_isr(void)
{
    CpuTimer0.InterruptCount++;

    // Update the CMPA and CMPB values
    ma = 0.5;// * (1 + m * sin(omega * n * Tsample));
    mb = 0.5;// * (1 + m * sin(omega * n * Tsample + Pi));
    mc = 0.5;// * (1 + m * sin(omega * n * Tsample - TwoPiByThree));
    md = 0.5;// * (1 + m * sin(omega * n * Tsample));
    me = 0.5;// * (1 + m * sin(omega * n * Tsample +Pi));
    PHASE_SHIFT= PHASE_SHIFT_Default + (phi-30)*TB_Period/360;

    EPwm1Regs.CMPA.bit.CMPA = TB_Period * ma; // Switch a
    EPwm2Regs.CMPA.bit.CMPA = TB_Period * mb; // Switch b
    EPwm3Regs.CMPA.bit.CMPA = TB_Period * mc; // Switch c
    EPwm4Regs.CMPA.bit.CMPA = TB_Period * md; // Switch d
    EPwm5Regs.CMPA.bit.CMPA = TB_Period * me; // Switch e
    EPwm6Regs.CMPA.bit.CMPA = TB_Period * ma; // Switch a
    EPwm7Regs.CMPA.bit.CMPA = TB_Period * mb; // Switch b
    EPwm8Regs.CMPA.bit.CMPA = TB_Period * mc; // Switch c
    EPwm9Regs.CMPA.bit.CMPA = TB_Period * md; // Switch d
    EPwm10Regs.CMPA.bit.CMPA = TB_Period * md; // Switch d
    EPwm10Regs.TBPHS.bit.TBPHS = PHASE_SHIFT;
    EPwm2Regs.TBPHS.bit.TBPHS =  PHASE_SHIFT - 1333;
    EPwm3Regs.TBPHS.bit.TBPHS =  PHASE_SHIFT + 1333;
     if (n%2 == 0)
     {
         buff1[cnt] = mb; // GpioDataRegs.GPADAT.all;
        cnt = cnt + 1;
     }
     if (n >= 1000)
     {
         n = 0;
        cnt = 0;
     }
     else
     {
         n = n + 1;
     }

    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1; // Acknowledge this (Timer0) interrupt to receive more interrupts from the same group (1).
}


void GPIOConfig(void)
{
    EALLOW; // This is needed to write to EALLOW protected registers

    GpioCtrlRegs.GPAPUD.bit.GPIO0 = 1; // Disable pull-up to reduce power consumption
    GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1; // GPIO0 selected as EPWM1A (pin40) in GPIO and Peripheral Muxing  dock pin 49

    GpioCtrlRegs.GPAPUD.bit.GPIO1 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1; // GPIO1 == EPWM1B LX pin39  dock pin 51

    GpioCtrlRegs.GPAPUD.bit.GPIO2 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 1; // GPIO2 == EPWM2A LX pin38  dock pin 53

    GpioCtrlRegs.GPAPUD.bit.GPIO3 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO3 = 1; // GPIO3 == EPWM2B LX pin37  dock pin 55

    GpioCtrlRegs.GPAPUD.bit.GPIO4 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO4 = 1; // GPIO4 == EPWM3A LX pin36  dock pin 50

    GpioCtrlRegs.GPAPUD.bit.GPIO5 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO5 = 1; // GPIO5 == EPWM3B LX pin35  dock pin 52

    GpioCtrlRegs.GPAPUD.bit.GPIO6 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 1; // GPIO6 == EPWM4A LX pin80  dock pin 54

    GpioCtrlRegs.GPAPUD.bit.GPIO7 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 1; // GPIO7 == EPWM4B LX pin79  dock pin 56

    GpioCtrlRegs.GPAPUD.bit.GPIO8 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO8 = 1; // GPIO8 == EPWM5A LX pin78  dock pin 57

    GpioCtrlRegs.GPAPUD.bit.GPIO9 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO9 = 1; // GPIO9 == EPWM5B LX pin77  dock pin 59

    GpioCtrlRegs.GPAPUD.bit.GPIO10 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO10 = 1; // GPIO10 == EPWM6A LX pin76  dock pin 61

    GpioCtrlRegs.GPAPUD.bit.GPIO11 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO11 = 1; // GPIO11 == EPWM6B LX pin74  dock pin 63

    GpioCtrlRegs.GPAPUD.bit.GPIO12 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO12 = 1; // GPIO12 == EPWM7A  dock pin 58

    GpioCtrlRegs.GPAPUD.bit.GPIO13 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO13 = 1; // GPIO13 == EPWM7B  dock pin 60

    GpioCtrlRegs.GPAPUD.bit.GPIO14 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO14 = 1; // GPIO14 == EPWM8A  dock pin 62

    GpioCtrlRegs.GPAPUD.bit.GPIO15 = 1;
    GpioCtrlRegs.GPAMUX1.bit.GPIO15 = 1; // GPIO15 == EPWM8B  dock pin 64

    GpioCtrlRegs.GPAPUD.bit.GPIO16 = 1;
    GpioCtrlRegs.GPAGMUX2.bit.GPIO16 = 1;
    GpioCtrlRegs.GPAMUX2.bit.GPIO16 = 1; // GPIO16 == EPWM9A  dock pin 67

    GpioCtrlRegs.GPAPUD.bit.GPIO17 = 1;
    GpioCtrlRegs.GPAGMUX2.bit.GPIO17 = 1;
    GpioCtrlRegs.GPAMUX2.bit.GPIO17 = 1; // GPIO17 == EPWM9B  dock pin 69

    GpioCtrlRegs.GPAPUD.bit.GPIO18 = 1;
    GpioCtrlRegs.GPAGMUX2.bit.GPIO18 = 1;
    GpioCtrlRegs.GPAMUX2.bit.GPIO18 = 1; // GPIO16 == EPWM10A  dock pin 71

    GpioCtrlRegs.GPAPUD.bit.GPIO19 = 1;
    GpioCtrlRegs.GPAGMUX2.bit.GPIO19 = 1;
    GpioCtrlRegs.GPAMUX2.bit.GPIO19 = 1; // GPIO17 == EPWM10B  dock pin 73

    EDIS; // This is needed to disable write to EALLOW protected registers
}

void EPwmConfig(void)
    {

    EPwm1Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm1Regs.TBPHS.bit.TBPHS = 0x0000;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm1Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up
    EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE; // Disable phase shift
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm1Regs.TBCTL.bit.SYNCOSEL = 1;

    EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;
    EPwm1Regs.AQCTLA.bit.ZRO = AQ_SET;
    //EPwm1Regs.AQCTLB.bit.CBU = AQ_SET;
    //EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;

    // Active high complementary PWMs - Setup the dead band // DeadBand = 0.5 us
    EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm1Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm1Regs.DBRED.bit.DBRED = 20; // RED = DBRED  T_TBCLK // RED = 0.2us; T_TBCLK = EPWMCLK = 100 MHz
    EPwm1Regs.DBFED.bit.DBFED = 20; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm2Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm2Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default - 1333;     //2667 for 240 deg phase B Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm2Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm2Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm2Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm2Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm2Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm2Regs.TBCTL.bit.PHSDIR = 1;

    EPwm2Regs.AQCTLA.bit.CAU = 1;
    EPwm2Regs.AQCTLA.bit.ZRO = 2;
    //EPwm2Regs.AQCTLB.bit.CBU = AQ_SET;
    //EPwm2Regs.AQCTLB.bit.CBD = AQ_CLEAR;

    // Active high complementary PWMs - Setup the deadband
    EPwm2Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm2Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm2Regs.DBRED.bit.DBRED = 20; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm2Regs.DBFED.bit.DBFED = 20; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm3Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm3Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default + 1333;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm3Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm3Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm3Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm3Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm3Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm3Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm3Regs.TBCTL.bit.PHSDIR = 1;

    EPwm3Regs.AQCTLA.bit.CAU = 1;
    EPwm3Regs.AQCTLA.bit.ZRO = 2;
    //EPwm3Regs.AQCTLB.bit.CBU = AQ_SET;
    //EPwm3Regs.AQCTLB.bit.CBD = AQ_CLEAR;

    // Active high complementary PWMs - Setup the deadband
    EPwm3Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm3Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm3Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm3Regs.DBRED.bit.DBRED = 20; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm3Regs.DBFED.bit.DBFED = 20; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm4Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm4Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm4Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm4Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm4Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm4Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm4Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm4Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm4Regs.TBCTL.bit.PHSDIR = 1;

    EPwm4Regs.AQCTLA.bit.CAU = 1;
    EPwm4Regs.AQCTLA.bit.ZRO = 2;
    //EPwm3Regs.AQCTLB.bit.CBU = AQ_SET;
    //EPwm3Regs.AQCTLB.bit.CBD = AQ_CLEAR;

    // Active high complementary PWMs - Setup the deadband
    EPwm4Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm4Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm4Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm4Regs.DBRED.bit.DBRED = 25; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm4Regs.DBFED.bit.DBFED = 25; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm5Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm5Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm5Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm5Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm5Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm5Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm5Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm5Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm5Regs.TBCTL.bit.PHSDIR = 1;

    EPwm5Regs.AQCTLA.bit.CAU = 1;
    EPwm5Regs.AQCTLA.bit.ZRO = 2;
    //EPwm5Regs.AQCTLA.bit.CAU = AQ_SET; //DAB case
    //EPwm5Regs.AQCTLA.bit.CAD = AQ_CLEAR; // DAB case

    // Active high complementary PWMs - Setup the deadband
    EPwm5Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm5Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm5Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm5Regs.DBRED.bit.DBRED = 25; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm5Regs.DBFED.bit.DBFED = 25; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm6Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm6Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default - 1333;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm6Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm6Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm6Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm6Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm6Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm6Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm6Regs.TBCTL.bit.PHSDIR = 1;

    EPwm6Regs.AQCTLA.bit.CAU = 2;
    EPwm6Regs.AQCTLA.bit.ZRO = 1;
    //EPwm6Regs.AQCTLA.bit.CAU = AQ_SET; //DAB case
    //EPwm6Regs.AQCTLA.bit.CAD = AQ_CLEAR; // DAB case

    // Active high complementary PWMs - Setup the deadband
    EPwm6Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm6Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm6Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm6Regs.DBRED.bit.DBRED = 25; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm6Regs.DBFED.bit.DBFED = 25; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm7Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm7Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default - 1333;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm7Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm7Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm7Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm7Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm7Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm7Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm7Regs.TBCTL.bit.PHSDIR = 1;

    EPwm7Regs.AQCTLA.bit.CAU = 2;
    EPwm7Regs.AQCTLA.bit.ZRO = 1;
    //EPwm7Regs.AQCTLA.bit.CAU = AQ_SET; //DAB case
    //EPwm7Regs.AQCTLA.bit.CAD = AQ_CLEAR; // DAB case

    // Active high complementary PWMs - Setup the deadband
    EPwm7Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm7Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm7Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm7Regs.DBRED.bit.DBRED = 25; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm7Regs.DBFED.bit.DBFED = 25; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm8Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm8Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default + 1333;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm8Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm8Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm8Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm8Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm8Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm8Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm8Regs.TBCTL.bit.PHSDIR = 1;

    EPwm8Regs.AQCTLA.bit.CAU = 2;
    EPwm8Regs.AQCTLA.bit.ZRO = 1;
    //EPwm8Regs.AQCTLA.bit.CAU = AQ_SET; //DAB case
    //EPwm8Regs.AQCTLA.bit.CAD = AQ_CLEAR; // DAB case

    // Active high complementary PWMs - Setup the deadband
    EPwm8Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm8Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm8Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm8Regs.DBRED.bit.DBRED = 25; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm8Regs.DBFED.bit.DBFED = 25; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm9Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm9Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default + 1333;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm9Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm9Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm9Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm9Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm9Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm9Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm9Regs.TBCTL.bit.PHSDIR = 1;

    EPwm9Regs.AQCTLA.bit.CAU = 2;
    EPwm9Regs.AQCTLA.bit.ZRO = 1;
    //EPwm9Regs.AQCTLA.bit.CAU = AQ_SET; //DAB case
    //EPwm9Regs.AQCTLA.bit.CAD = AQ_CLEAR; // DAB case

    // Active high complementary PWMs - Setup the deadband
    EPwm9Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm9Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm9Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm9Regs.DBRED.bit.DBRED = 25; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm9Regs.DBFED.bit.DBFED = 25; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

    ////////////// TPWM = 2 * TBPRD * TBCLK
    EPwm10Regs.TBPRD = TB_Period;            // Set Timer period
    EPwm10Regs.TBPHS.bit.TBPHS = PHASE_SHIFT_Default;     // Set Phase = 0, If TBCTL[PHSEN] = 1, then the TBCTR will be loaded with the TBPHS when a synchronization event occurs.
    EPwm10Regs.TBCTR = 0x0000;               // Clear Counter
    EPwm10Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up-down
    EPwm10Regs.TBCTL.bit.PHSEN = TB_ENABLE; // Disable phase shift
    EPwm10Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;// TBCLK = EPWMCLK/(HSPCLKDIV * CLKDIV)
    EPwm10Regs.TBCTL.bit.CLKDIV = TB_DIV1;

    EPwm10Regs.TBCTL.bit.SYNCOSEL = 0;
    EPwm10Regs.TBCTL.bit.PHSDIR = 1;

    EPwm10Regs.AQCTLA.bit.CAU = 1;
    EPwm10Regs.AQCTLA.bit.ZRO = 2;
    //EPwm10Regs.AQCTLA.bit.CAU = AQ_SET; //DAB case
    //EPwm10Regs.AQCTLA.bit.CAD = AQ_CLEAR; // DAB case

    // Active high complementary PWMs - Setup the deadband
    EPwm10Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE; // S1=1, S0=1
    EPwm10Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC; // S3=1, S2=0
    EPwm10Regs.DBCTL.bit.IN_MODE = DBA_ALL; // S5=0, S4=0
    EPwm10Regs.DBRED.bit.DBRED = 20; // RED = DBRED  T_TBCLK  => DB(F/R)ED*10ns
    EPwm10Regs.DBFED.bit.DBFED = 20; // FED = DBFED  T_TBCLK  => DB(F/R)ED*10ns

}
