//###########################################################################
//
// FILE:   F2837xD_Adc_defines.h
//
// TITLE:  #defines used in ADC examples
//
//###########################################################################
// $TI Release: F2837xD Support Library v3.10.00.00 $
// $Release Date: Tue May 26 17:13:46 IST 2020 $
// $Copyright:
// Copyright (C) 2013-2020 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

#ifndef F2837xD_ADC_DEFINES_H
#define F2837xD_ADC_DEFINES_H

#ifdef __cplusplus
extern "C" {
#endif

//
// Defines
//
#define ADC_CHANNEL_0        0
#define ADC_CHANNEL_1        1
#define ADC_CHANNEL_2        2
#define ADC_CHANNEL_3        3
#define ADC_CHANNEL_4        4
#define ADC_CHANNEL_5        5
#define ADC_CHANNEL_6        6
#define ADC_CHANNEL_7        7

#define ADC_CHANNEL_8        8
#define ADC_CHANNEL_9        9
#define ADC_CHANNEL_10       10
#define ADC_CHANNEL_11       11
#define ADC_CHANNEL_12       12
#define ADC_CHANNEL_13       13
#define ADC_CHANNEL_14       14
#define ADC_CHANNEL_15       15

//
//definitions for specifying an ADC
//
#define ADC_ADCA 0
#define ADC_ADCB 1
#define ADC_ADCC 2
#define ADC_ADCD 3

//
//definitions for selecting ADC resolution
//
#ifndef _DUAL_HEADERS
#define ADC_RESOLUTION_12BIT 0
#define ADC_RESOLUTION_16BIT 1
#else
#define ADC_BITRESOLUTION_12BIT 0
#define ADC_BITRESOLUTION_16BIT 1
#endif
//
//definitions for selecting ADC signal mode
//(single-ended mode is only a valid mode for 12-bit resolution)
//
#define ADC_SIGNALMODE_SINGLE 0
#define ADC_SIGNALMODE_DIFFERENTIAL 1

#define ADC_TRIG_SW          0x00
#define ADC_TRIG_CPU1_TIMER0 0x01
#define ADC_TRIG_CPU1_TIMER1 0x02
#define ADC_TRIG_CPU1_TIMER2 0x03
#define ADC_TRIG_GPIO        0x04
#define ADC_TRIG_EPWM1A      0x05
#define ADC_TRIG_EPWM1B      0x06
#define ADC_TRIG_EPWM2A      0x07
#define ADC_TRIG_EPWM2B      0x08
#define ADC_TRIG_EPWM3A      0x09
#define ADC_TRIG_EPWM3B      0x0A
#define ADC_TRIG_EPWM4A      0x0B
#define ADC_TRIG_EPWM4B      0x0C
#define ADC_TRIG_EPWM5A      0x0D
#define ADC_TRIG_EPWM5B      0x0E
#define ADC_TRIG_EPWM6A      0x0F
#define ADC_TRIG_EPWM6B      0x10
#define ADC_TRIG_EPWM7A      0x11
#define ADC_TRIG_EPWM7B      0x12
#define ADC_TRIG_EPWM8A      0x13
#define ADC_TRIG_EPWM8B      0x14
#define ADC_TRIG_EPWM9A      0x15
#define ADC_TRIG_EPWM9B      0x16
#define ADC_TRIG_EPWM10A     0x17
#define ADC_TRIG_EPWM10B     0x18
#define ADC_TRIG_EPWM11A     0x19
#define ADC_TRIG_EPWM11B     0x1A
#define ADC_TRIG_EPWM12A     0x1B
#define ADC_TRIG_EPWM12B     0x1C
#define ADC_TRIG_CPU2_TIMER0 0x1D
#define ADC_TRIG_CPU2_TIMER1 0x1E
#define ADC_TRIG_CPU2_TIMER2 0x1F




// The following pointer to a function call calibrates the ADC reference,
// DAC offset, and internal oscillators
//
#define Device_cal ((void (*)(void))((uintptr_t)0x070282))

//
// The following pointers to functions calibrate the ADC linearity.  Use this
// in the AdcSetMode(...) function only
//
#define CalAdcaINL (void   (*)(void))0x0703B4
#define CalAdcbINL (void   (*)(void))0x0703B2
#define CalAdccINL (void   (*)(void))0x0703B0
#define CalAdcdINL (void   (*)(void))0x0703AE

//
// The following pointer to a function call looks up the ADC offset trim for a
// given condition. Use this in the AdcSetMode(...) function only.
//
#define GetAdcOffsetTrimOTP (Uint16 (*)(Uint16 OTPoffset))0x0703AC

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif   // - end of F2837xD_ADC_DEFINES_H

//
// End of file
//
